/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.item.script;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.nbt.GSKONBTUtil;
import github.thelawf.gensokyoontology.core.init.itemtab.GSKOItemTab;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptReadOnlyItem
extends Item {
    public static final String TYPE_HIGHLIGHT = "\u00a76";
    public static final String NAME_HIGHLIGHT = "\u00a7d";
    public static final String VALUE_HIGHLIGHT = "\u00a7a";
    public static final String STRING_HIGHLIGHT = "\u00a7b";
    public static final String EXCEPTION_HIGHLIGHT = "\u00a7c";
    public static final String RESET_HIGHLIGHT = "\u00a7r";
    public static final ITextComponent FILED_TYPE_TIP = GensokyoOntology.withTranslation("tooltip.", ".script_builder.field_type");
    public static final ITextComponent FILED_NAME_TIP = GensokyoOntology.withTranslation("tooltip.", ".script_builder.field_name");
    public static final ITextComponent FILED_VALUE_TIP = GensokyoOntology.withTranslation("tooltip.", ".script_builder.field_value");

    public ScriptReadOnlyItem() {
        super(new Item.Properties().func_200916_a((ItemGroup)GSKOItemTab.GSKO_ITEM_TAB));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull PlayerEntity playerIn, @NotNull Hand handIn) {
        this.addReadOnlyData(worldIn, playerIn, playerIn.func_184586_b(handIn));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public abstract void addReadOnlyData(World var1, PlayerEntity var2, ItemStack var3);

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            CompoundNBT nbt = stack.func_77978_p();
            tooltip.add(FILED_TYPE_TIP);
            tooltip.add((ITextComponent)new StringTextComponent(TYPE_HIGHLIGHT + nbt.func_74779_i("type")));
            tooltip.add(FILED_NAME_TIP);
            tooltip.add((ITextComponent)new StringTextComponent(NAME_HIGHLIGHT + nbt.func_74779_i("name")));
            tooltip.add(FILED_VALUE_TIP);
            if (GSKONBTUtil.containsPrimitiveType(nbt)) {
                tooltip.add((ITextComponent)new StringTextComponent(VALUE_HIGHLIGHT + GSKONBTUtil.getFromValue(nbt).func_150285_a_()));
            } else if (GSKONBTUtil.containsAllowedType(nbt)) {
                GSKONBTUtil.getMemberValues(nbt).forEach(s -> tooltip.add((ITextComponent)new StringTextComponent(s)));
            }
        }
    }
}

