/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.item.touhou;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AyaFans
extends Item
implements IRayTraceReader {
    public AyaFans(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, PlayerEntity playerIn, @NotNull Hand handIn) {
        if (playerIn.func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        AxisAlignedBB aabb = new AxisAlignedBB(playerIn.func_213303_ch().func_178788_d(new Vector3d(5.0, 10.0, 5.0)), playerIn.func_213303_ch().func_178787_e(new Vector3d(5.0, 10.0, 5.0)));
        Vector3d lookVec = playerIn.func_70040_Z();
        Predicate<LivingEntity> predicate = living -> !(living instanceof PlayerEntity);
        this.getEntityWithinSphere(worldIn, LivingEntity.class, predicate, aabb, 12.0f).forEach(living -> living.func_233627_a_(3.0f, -lookVec.field_72450_a, -lookVec.field_72449_c));
        AxisAlignedBB box = new AxisAlignedBB(playerIn.func_213303_ch().func_178788_d(new Vector3d(12.0, 12.0, 12.0)), playerIn.func_213303_ch().func_178787_e(new Vector3d(12.0, 12.0, 12.0)));
        this.getEntityWithinSphere(worldIn, ProjectileEntity.class, box, 12.0f).forEach(projectile -> this.applyProjectileKnockback((ProjectileEntity)projectile, 3.0f, -lookVec.field_72450_a, -lookVec.field_72449_c));
        if (worldIn.field_72995_K) {
            for (int i = 0; i < GSKOMathUtil.randomRange(30, 60); ++i) {
                worldIn.func_195590_a((IParticleData)ParticleTypes.field_197613_f, false, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), lookVec.field_72450_a + field_77697_d.nextDouble(), lookVec.field_72448_b + field_77697_d.nextDouble(), lookVec.field_72449_c + field_77697_d.nextDouble());
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void applyProjectileKnockback(ProjectileEntity projectile, float strength, double ratioX, double ratioZ) {
        if (!(strength <= 0.0f)) {
            Vector3d vector3d = projectile.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)strength);
            projectile.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, projectile.func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)strength) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
        }
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)GensokyoOntology.withTranslation("tooltip.", ".aya_fans"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @NotNull
    public UseAction func_77661_b(@NotNull ItemStack stack) {
        return UseAction.BLOCK;
    }
}

