/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.item.touhou;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.client.gui.screen.skill.GoheiModeSelectScreen;
import github.thelawf.gensokyoontology.common.entity.misc.DreamSealEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.InYoJadeDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.EnumUtil;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.itemtab.GSKOItemTab;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HakureiGohei
extends Item
implements IRayTraceReader {
    public static final ITextComponent TITLE = GensokyoOntology.withTranslation("gui.", ".hakurei_gohei.title");

    public HakureiGohei(Item.Properties properties) {
        super(properties);
    }

    private void setMode(CompoundNBT nbt, Mode mode) {
        nbt.func_74768_a("mode", mode.ordinal());
    }

    public static Mode getMode(CompoundNBT nbt) {
        return Mode.values()[nbt.func_74762_e("mode")];
    }

    private Mode switchMode(CompoundNBT nbt) {
        return EnumUtil.switchEnum(Mode.class, HakureiGohei.getMode(nbt));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, PlayerEntity playerIn, @NotNull Hand handIn) {
        if (playerIn.func_184811_cZ().func_185141_a((Item)this) && !playerIn.func_184812_l_()) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77978_p() != null) {
            switch (HakureiGohei.getMode(stack.func_77978_p())) {
                default: {
                    InYoJadeDanmakuEntity inYoJade = new InYoJadeDanmakuEntity(worldIn, (Entity)playerIn);
                    DanmakuUtil.shootDanmaku(worldIn, playerIn, inYoJade, 1.0f, 0.0f);
                    break;
                }
                case DREAM_SEAL: {
                    this.fireDreamSeal(worldIn, playerIn);
                }
                case SPELL_CARD: 
            }
        }
        if (playerIn.func_184812_l_()) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public void fireDreamSeal(World worldIn, PlayerEntity playerIn) {
        for (int i = 0; i < 8; ++i) {
            DanmakuColor color;
            int i1 = i % 3;
            switch (i1) {
                default: {
                    color = DanmakuColor.RED;
                    break;
                }
                case 1: {
                    color = DanmakuColor.BLUE;
                    break;
                }
                case 2: {
                    color = DanmakuColor.GREEN;
                }
            }
            Vector3d vector3d = i % 2 == 0 ? new Vector3d(2.0, 3.0, 0.0).func_178789_a((float)Math.PI * 2 / (float)i) : new Vector3d(2.0, 3.0, 0.0).func_178789_a((float)Math.PI * -2 / (float)i);
            Vector3d initPos = vector3d.func_178787_e(playerIn.func_213303_ch());
            DreamSealEntity dreamSeal = new DreamSealEntity(worldIn, (LivingEntity)playerIn, color);
            dreamSeal.func_189654_d(true);
            dreamSeal.func_70186_c(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.2f, 0.0f);
            dreamSeal.func_70012_b(initPos.field_72450_a, initPos.field_72448_b, initPos.field_72449_c, playerIn.field_70177_z, playerIn.field_70125_A);
            worldIn.func_217376_c((Entity)dreamSeal);
        }
    }

    public void func_150895_a(@NotNull ItemGroup group, @NotNull NonNullList<ItemStack> items) {
        if (group == GSKOItemTab.GSKO_ITEM_TAB) {
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("mode", Mode.DANMAKU.ordinal());
            itemStack.func_77982_d(tag);
            items.add((Object)itemStack);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent text = GensokyoOntology.withTranslation("tooltip.", ".hakurei_gohei.mode");
        if (stack.func_77978_p() != null) {
            switch (HakureiGohei.getMode(stack.func_77978_p())) {
                default: {
                    tooltip.add((ITextComponent)GoheiModeSelectScreen.DANMAKU);
                    break;
                }
                case SPELL_CARD: {
                    break;
                }
                case DREAM_SEAL: {
                    tooltip.add((ITextComponent)GoheiModeSelectScreen.DREAM_SEAL);
                }
            }
        }
    }

    @NotNull
    public UseAction func_77661_b(@NotNull ItemStack stack) {
        return UseAction.BLOCK;
    }

    public static enum Mode {
        DANMAKU,
        SPELL_CARD,
        DREAM_SEAL;

    }
}

