/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.item.touhou;

import com.google.common.collect.ImmutableList;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.entity.misc.LaserSourceEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KoishiEyeOpen
extends Item
implements IRayTraceReader {
    private int totalCount = 0;

    public KoishiEyeOpen(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull PlayerEntity playerIn, @NotNull Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("total_count")) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("total_count", playerIn.field_70173_aa + this.func_77626_a(stack));
            stack.func_77982_d(nbt);
        }
        LaserSourceEntity laserSource = new LaserSourceEntity(worldIn, (Entity)playerIn);
        laserSource.init(200, 40, 85.0f);
        laserSource.setARGB(-1996554240);
        laserSource.func_70012_b(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)playerIn.func_70047_e() * 0.5, playerIn.func_226281_cx_(), playerIn.field_70177_z, playerIn.field_70125_A);
        worldIn.func_217376_c((Entity)laserSource);
        playerIn.func_184598_c(handIn);
        if (stack.func_77978_p() != null && playerIn.field_70173_aa < stack.func_77978_p().func_74762_e("total_count")) {
            if (playerIn.field_70173_aa < stack.func_77978_p().func_74762_e("total_count")) {
                playerIn.func_184597_cx();
                this.applyRayDamage(worldIn, (LivingEntity)playerIn, stack, 15);
            } else {
                this.func_77654_b(stack, worldIn, (LivingEntity)playerIn);
            }
        }
        if (playerIn.func_184812_l_()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void lasers(World worldIn, PlayerEntity playerIn) {
        ImmutableList colors = ImmutableList.of((Object)-1996554240, (Object)-1996518400, (Object)-1996488960, (Object)-2013200640, (Object)-2013200385, (Object)-2013265665, (Object)-1996553985, (Object)-2004877184);
        for (int i = 0; i < colors.size(); ++i) {
            LaserSourceEntity laser = new LaserSourceEntity(worldIn, (Entity)playerIn);
            laser.init(500, 40, 120.0f);
            laser.setARGB((Integer)colors.get(i));
            laser.func_70012_b(playerIn.func_226277_ct_() + (double)i / 2.0, playerIn.func_226278_cu_() + (double)playerIn.func_70047_e() * 0.5, playerIn.func_226281_cx_(), 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)laser);
        }
    }

    public void applyRayDamage(World worldIn, LivingEntity user, ItemStack stack, int radius) {
        Predicate<LivingEntity> predicate = living -> living instanceof PlayerEntity;
        if (predicate.test(user)) {
            PlayerEntity player = (PlayerEntity)user;
            if (player.func_184811_cZ().func_185141_a((Item)this)) {
                return;
            }
            AxisAlignedBB box = this.createCubeBox(player.func_213303_ch(), radius);
            Vector3d start = player.func_213303_ch();
            Vector3d vec = new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c);
            Vector3d vector3d = start.func_178787_e(vec.func_186678_a(10.0));
            for (int i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 / (double)this.func_77626_a(stack) * (double)this.totalCount;
                Vector3d end = vector3d.func_178785_b(0.7853982f * (float)i).func_178785_b((float)angle);
                this.getEntityWithinSphere(worldIn, LivingEntity.class, predicate.negate(), box, 12.0f).stream().filter(living -> this.isIntersecting(start, end, living.func_174813_aQ().func_72317_d(0.0, -1.0, 0.0))).forEach(living -> living.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 8.0f));
                if (!(angle >= Math.PI * 2)) continue;
                this.totalCount = 0;
            }
        }
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        stack.func_77982_d(new CompoundNBT());
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull LivingEntity entityLiving) {
        stack.func_77982_d(new CompoundNBT());
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        return 50;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)GensokyoOntology.withTranslation("tooltip.", ".koishi_eye_open"));
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)GensokyoOntology.withTranslation("tooltip.", ".koishi_eye_open.comment"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @NotNull
    public UseAction func_77661_b(@NotNull ItemStack stack) {
        return UseAction.BOW;
    }
}

