/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.item.touhou;

import github.thelawf.gensokyoontology.common.nbt.GSKONBTUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class SetBlockWand
extends Item {
    BlockState blockState = Blocks.field_150348_b.func_176223_P();
    Mode mode = Mode.CIRCLE;
    CompoundNBT nbt = new CompoundNBT();

    public SetBlockWand(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (Screen.func_231173_s_()) {
            this.blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
        }
        ItemStack itemStack = Objects.requireNonNull(context.func_195999_j()).func_184614_ca();
        if (!context.func_195991_k().field_72995_K) {
            BlockPos pos = context.func_195995_a();
            if (this.mode == Mode.CIRCLE && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("centerX") && itemStack.func_77978_p().func_74764_b("centerY") && itemStack.func_77978_p().func_74764_b("centerZ")) {
                this.nbt.func_74768_a("centerX", pos.func_177958_n());
                this.nbt.func_74768_a("centerY", pos.func_177956_o());
                this.nbt.func_74768_a("centerZ", pos.func_177952_p());
                itemStack.func_77982_d(this.nbt);
                context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("set_block_item.message.set_center", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), context.func_195999_j().func_110124_au());
            } else {
                CompoundNBT nbt = itemStack.func_77978_p();
                if (nbt != null && nbt.func_74764_b("centerX") && nbt.func_74764_b("centerY") && nbt.func_74764_b("centerZ")) {
                    int centerX = nbt.func_74762_e("centerX");
                    int centerY = nbt.func_74762_e("centerY");
                    int centerZ = nbt.func_74762_e("centerZ");
                    int radius = (int)Math.sqrt(Math.pow(pos.func_177958_n() - centerX, 2.0) + Math.pow(pos.func_177956_o() - centerY, 2.0) + Math.pow(pos.func_177952_p() - centerZ, 2.0));
                    nbt.func_74768_a("radius", radius);
                    itemStack.func_77982_d(nbt);
                    context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.message.set_radius", new Object[]{radius}), context.func_195999_j().func_110124_au());
                    this.placeCircleBlock(new BlockPos(centerX, centerY, centerZ), radius);
                    nbt.func_82580_o("centerX");
                    nbt.func_82580_o("centerY");
                    nbt.func_82580_o("centerZ");
                    nbt.func_82580_o("radius");
                    itemStack.func_77982_d(nbt);
                }
            }
            if (this.mode == Mode.BEZIER_CURVE && itemStack.func_77978_p() == null) {
                this.nbt.func_74768_a("startX", pos.func_177958_n());
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (Screen.func_231174_t_()) {
            switch (this.mode) {
                case CIRCLE: {
                    this.mode = Mode.ECLIPSE;
                    this.nbt = GSKONBTUtil.removeAllChildNBT(this.nbt);
                    break;
                }
                case ECLIPSE: {
                    this.mode = Mode.RECTANGLE;
                    this.nbt = GSKONBTUtil.removeAllChildNBT(this.nbt);
                    break;
                }
                case RECTANGLE: {
                    this.mode = Mode.BEZIER_CURVE;
                    this.nbt = GSKONBTUtil.removeAllChildNBT(this.nbt);
                    break;
                }
                case BEZIER_CURVE: {
                    this.mode = Mode.CIRCLE;
                    this.nbt = GSKONBTUtil.removeAllChildNBT(this.nbt);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gensokyoontologyset_block_wand.mode"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gensokyoontologyset_block_wand.key_hint"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void placeCircleBlock(BlockPos posIn, int radius) {
    }

    public void placeBezierCurveBlock() {
    }

    public static enum Mode {
        CIRCLE("circle_mode"),
        ECLIPSE("eclipse_mode"),
        RECTANGLE("rectangle_mode"),
        BEZIER_CURVE("bezier_mode");

        public final String id;

        private Mode(String id) {
            this.id = id;
        }
    }
}

