/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.nbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class GSKONBTUtil {
    public static boolean hasItemStack(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77969_a(new ItemStack((IItemProvider)item))) continue;
            return true;
        }
        return false;
    }

    public static CompoundNBT wrap(Supplier<CompoundNBT> supplier) {
        return supplier.get();
    }

    public static int operateAndGet(BiFunction<IntNBT, IntNBT, IntNBT> action, IntNBT left, IntNBT right) {
        return action.apply(left, right).func_150287_d();
    }

    public static CompoundNBT getNonNullTag(ItemStack stack, String key) {
        if (stack.func_77978_p() == null) {
            return new CompoundNBT();
        }
        return stack.func_77978_p();
    }

    public static CompoundNBT getNonNullTags(ItemStack stack, String ... keys) {
        if (!GSKONBTUtil.hasAndContainsTags(stack, keys)) {
            return new CompoundNBT();
        }
        return stack.func_77978_p();
    }

    public static boolean hasAndContainsTag(ItemStack stack, String key) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(key);
    }

    public static boolean hasAndContainsTags(ItemStack stack, String ... keys) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        return Arrays.stream(keys).allMatch(arg_0 -> ((CompoundNBT)nbt).func_74764_b(arg_0));
    }

    public static int getFirstItemIndex(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77969_a(new ItemStack((IItemProvider)item))) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public static BlockPos readPosFromStack(ItemStack stack, String nbtKey) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(nbtKey)) {
            int[] pos = stack.func_77978_p().func_74759_k(nbtKey);
            BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
            Vector3d posVec = GSKONBTUtil.blockPosToVec(blockPos);
            return blockPos;
        }
        return BlockPos.field_177992_a;
    }

    public static CompoundNBT removeAllChildNBT(CompoundNBT nbt) {
        if (nbt != null) {
            for (String key : nbt.func_150296_c()) {
                nbt.func_82580_o(key);
            }
        }
        return nbt;
    }

    public static CompoundNBT removeAllChildNBT(ItemStack stack, CompoundNBT nbt) {
        if (stack.func_77978_p() == nbt && nbt != null) {
            for (String key : nbt.func_150296_c()) {
                nbt.func_82580_o(key);
                stack.func_77982_d(nbt);
            }
            return nbt;
        }
        return new CompoundNBT();
    }

    public static CompoundNBT putStory() {
        String key = "story";
        String storyText = "";
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(key, storyText);
        return nbt;
    }

    public static CompoundNBT putRandomStory(List<String> stories) {
        String key = "story";
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(key, stories.get(new Random().nextInt(stories.size())));
        return nbt;
    }

    public static <T> CompoundNBT putStoryIf(Predicate<T> predicate, T t) {
        if (predicate.test(t)) {
            String key = "story";
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a(key, predicate.toString());
            return nbt;
        }
        return new CompoundNBT();
    }

    public static ItemStack removeAllChildNBTFromStack(ItemStack stack, CompoundNBT nbt) {
        if (stack.func_77978_p() == nbt && nbt != null) {
            for (String key : nbt.func_150296_c()) {
                nbt.func_82580_o(key);
                stack.func_77982_d(nbt);
            }
            return stack;
        }
        return new ItemStack((IItemProvider)stack.func_77973_b());
    }

    public static Vector3d blockPosToVec(BlockPos blockPos) {
        return new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
    }

    public static BlockPos vecToBlockPos(Vector3d vector3d) {
        return new BlockPos(new Vector3i(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
    }

    public static boolean containsPrimitiveType(CompoundNBT nbt) {
        if (!nbt.func_74764_b("type")) {
            return false;
        }
        switch (nbt.func_74779_i("type")) {
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "string": 
            case "boolean": {
                return true;
            }
        }
        return false;
    }

    public static INBT getFromValue(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof NumberNBT) {
            return GSKONBTUtil.getAsNumber(nbt);
        }
        if (nbt.func_74781_a("value") instanceof StringNBT) {
            return nbt.func_74781_a("value");
        }
        if (nbt.func_74781_a("value") instanceof ByteNBT) {
            ByteNBT byteNBT = (ByteNBT)nbt.func_74781_a("value");
            if (byteNBT != null) {
                return byteNBT.func_150287_d() == 0 ? StringNBT.func_229705_a_((String)"false") : StringNBT.func_229705_a_((String)"true");
            }
        } else if (nbt.func_74781_a("value") instanceof CompoundNBT) {
            return nbt.func_74781_a("value");
        }
        return new CompoundNBT();
    }

    public static NumberNBT getAsNumber(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof IntNBT) {
            return (IntNBT)nbt.func_74781_a("value");
        }
        if (nbt.func_74781_a("value") instanceof LongNBT) {
            return (LongNBT)nbt.func_74781_a("value");
        }
        if (nbt.func_74781_a("value") instanceof FloatNBT) {
            return (FloatNBT)nbt.func_74781_a("value");
        }
        if (nbt.func_74781_a("value") instanceof DoubleNBT) {
            return (DoubleNBT)nbt.func_74781_a("value");
        }
        return IntNBT.func_229692_a_((int)0);
    }

    public static boolean isNumberType(CompoundNBT nbt) {
        return nbt.func_74779_i("type").equals("int") || nbt.func_74779_i("type").equals("long") || nbt.func_74779_i("type").equals("float") || nbt.func_74779_i("type").equals("double");
    }

    public static NumberNBT getNumberFromKey(CompoundNBT nbt, String key) {
        if (nbt.func_74781_a(key) instanceof IntNBT) {
            return (IntNBT)nbt.func_74781_a(key);
        }
        if (nbt.func_74781_a(key) instanceof LongNBT) {
            return (LongNBT)nbt.func_74781_a(key);
        }
        if (nbt.func_74781_a(key) instanceof FloatNBT) {
            return (FloatNBT)nbt.func_74781_a(key);
        }
        if (nbt.func_74781_a(key) instanceof DoubleNBT) {
            return (DoubleNBT)nbt.func_74781_a(key);
        }
        return IntNBT.func_229692_a_((int)0);
    }

    public static INBT getFromKey(CompoundNBT nbt, String key) {
        if (nbt.func_74781_a(key) instanceof NumberNBT) {
            return GSKONBTUtil.getNumberFromKey(nbt, key);
        }
        if (nbt.func_74781_a(key) instanceof StringNBT) {
            return nbt.func_74781_a(key);
        }
        if (nbt.func_74781_a(key) instanceof CompoundNBT) {
            return nbt.func_74781_a(key);
        }
        return new CompoundNBT();
    }

    public static CompoundNBT castToCompound(INBT inbt) {
        return inbt instanceof CompoundNBT ? (CompoundNBT)inbt : new CompoundNBT();
    }

    public static String getType(CompoundNBT nbt) {
        if (GSKONBTUtil.containsPrimitiveType(nbt)) {
            return nbt.func_74779_i("type");
        }
        return "undefined";
    }

    public static boolean containsAllowedType(CompoundNBT nbt) {
        if (!nbt.func_74764_b("type")) {
            return false;
        }
        if (GSKONBTUtil.containsPrimitiveType(nbt)) {
            return false;
        }
        switch (nbt.func_74779_i("type")) {
            case "vector3d": 
            case "world": 
            case "danmaku": 
            case "vector3d_list": 
            case "danmaku_list": {
                return true;
            }
        }
        return false;
    }

    public static List<String> getMemberValues(CompoundNBT nbt) {
        ArrayList<String> values = new ArrayList<String>();
        if (GSKONBTUtil.containsAllowedType(nbt)) {
            switch (nbt.func_74779_i("type")) {
                case "vector3d": {
                    return GSKONBTUtil.getVector3dValues(nbt);
                }
                case "world": 
                case "danmaku": {
                    CompoundNBT danmakuNBT = GSKONBTUtil.getCompoundValue(nbt);
                    values.add(String.valueOf(danmakuNBT.func_74762_e("danmakuType")));
                    values.add(String.valueOf(danmakuNBT.func_74762_e("danmakuColor")));
                }
            }
            return values;
        }
        return values;
    }

    public static List<String> getVector3dValues(CompoundNBT nbt) {
        ArrayList<String> values = new ArrayList<String>();
        CompoundNBT vectorNBT = GSKONBTUtil.getCompoundValue(nbt);
        values.add("\u00a7dX: \u00a7r\u00a7a" + GSKONBTUtil.getNumberFromKey(vectorNBT, "x").func_150286_g());
        values.add("\u00a7dY: \u00a7r\u00a7a" + GSKONBTUtil.getNumberFromKey(vectorNBT, "y").func_150286_g());
        values.add("\u00a7dZ: \u00a7r\u00a7a" + GSKONBTUtil.getNumberFromKey(vectorNBT, "z").func_150286_g());
        return values;
    }

    public static CompoundNBT getCompoundValue(CompoundNBT nbt) {
        if (!nbt.func_74764_b("value")) {
            return new CompoundNBT();
        }
        if (GSKONBTUtil.containsAllowedType(nbt) && nbt.func_74781_a("value") instanceof CompoundNBT) {
            return (CompoundNBT)nbt.func_74781_a("value");
        }
        return new CompoundNBT();
    }

    public static String getMemberValueAsString(CompoundNBT objectNBT, String memberKey) {
        if (!objectNBT.func_74764_b("value")) {
            return new CompoundNBT().toString();
        }
        if (GSKONBTUtil.containsAllowedType(objectNBT) && objectNBT.func_74781_a("value") instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)objectNBT.func_74781_a("value");
            if (compound != null) {
                return GSKONBTUtil.getFromKey(compound, memberKey).toString();
            }
        } else {
            return new CompoundNBT().toString();
        }
        return new CompoundNBT().toString();
    }

    public static String getMemberValueWithKey(CompoundNBT objectNBT, String memberKey, String keyText) {
        if (!objectNBT.func_74764_b("value")) {
            return new CompoundNBT().toString();
        }
        if (GSKONBTUtil.containsAllowedType(objectNBT) && objectNBT.func_74781_a("value") instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)objectNBT.func_74781_a("value");
            if (compound != null) {
                return keyText + GSKONBTUtil.getFromKey(compound, memberKey).toString();
            }
        } else {
            return new CompoundNBT().toString();
        }
        return new CompoundNBT().toString();
    }

    public static String getMemberValueWithFormat(CompoundNBT nbt, String memberKey, String keyText) {
        if (!nbt.func_74764_b("value")) {
            return new CompoundNBT().toString();
        }
        if (GSKONBTUtil.containsAllowedType(nbt) && nbt.func_74781_a("value") instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)nbt.func_74781_a("value");
            if (compound != null) {
                return "\u00a7d" + keyText + "\u00a7r" + "\u00a7a" + GSKONBTUtil.getFromKey(compound, memberKey).toString();
            }
        } else {
            return new CompoundNBT().toString();
        }
        return new CompoundNBT().toString();
    }

    public static ListNBT getListValue(CompoundNBT nbt) {
        if (nbt.func_74764_b("value")) {
            return new ListNBT();
        }
        if (GSKONBTUtil.containsAllowedType(nbt) && nbt.func_74781_a("value") instanceof ListNBT) {
            return (ListNBT)nbt.func_74781_a("value");
        }
        return new ListNBT();
    }

    public static List<CompoundNBT> getListCompound(ListNBT listNBT) {
        ArrayList<CompoundNBT> nbtList = new ArrayList<CompoundNBT>();
        if (listNBT.isEmpty()) {
            return nbtList;
        }
        listNBT.forEach(inbt -> {
            if (inbt instanceof CompoundNBT) {
                nbtList.add((CompoundNBT)inbt);
            }
        });
        return nbtList;
    }
}

