/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.nbt.script;

import github.thelawf.gensokyoontology.common.nbt.GSKONBTUtil;
import github.thelawf.gensokyoontology.common.nbt.script.BinaryOperation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GSKOScriptUtil {
    public static Map<String, INBT> getOptValueTagMap(CompoundNBT operationNBT) throws InvocationTargetException, IllegalAccessException {
        CompoundNBT value = GSKOScriptUtil.getScriptValue(operationNBT);
        Method method = ObfuscationReflectionHelper.findMethod(CompoundNBT.class, (String)"getTagMap", (Class[])new Class[0]);
        Object mapOBJ = method.invoke((Object)value, new Object[0]);
        if (mapOBJ instanceof Map) {
            return (Map)mapOBJ;
        }
        return new HashMap<String, INBT>();
    }

    public static Stack<CompoundNBT> traverseOpt(CompoundNBT parent, BinaryOperation operation, Stack<CompoundNBT> stack) throws InvocationTargetException, IllegalAccessException {
        Map<String, INBT> tagMapOfOpt = GSKOScriptUtil.getOptValueTagMap(parent);
        for (Map.Entry<String, INBT> entry : tagMapOfOpt.entrySet()) {
            CompoundNBT nbt;
            Predicate<Map.Entry> isAnOperation = e -> Arrays.stream(BinaryOperation.values()).map(bo -> bo.key).anyMatch(s -> ((INBT)e.getValue()).toString().equals(s));
            if (entry.getKey().equals("left") || entry.getKey().equals("right") && entry.getValue() instanceof CompoundNBT) {
                nbt = (CompoundNBT)entry.getValue();
                GSKOScriptUtil.traverseOpt(nbt, BinaryOperation.valueOf(tagMapOfOpt.get("operation").func_150285_a_()), stack);
            }
            if (!entry.getKey().equals("ref") && isAnOperation.test(entry)) continue;
            nbt = new CompoundNBT();
            nbt.func_74778_a("operation", operation.key);
            stack.push(parent);
            stack.push(nbt);
        }
        return stack;
    }

    public static CompoundNBT tryCalculateIterate(Stack<CompoundNBT> stack) {
        CompoundNBT left = stack.pop();
        CompoundNBT opt = stack.pop();
        CompoundNBT right = stack.pop();
        CompoundNBT result = new CompoundNBT();
        result.func_74778_a("type", left.func_74779_i("type"));
        stack.push(GSKOScriptUtil.putIf(result, GSKONBTUtil.isNumberType(left) && GSKONBTUtil.isNumberType(right) ? (Number)GSKOScriptUtil.calculateNumber(left, BinaryOperation.valueOf(opt.func_74779_i("operation")), right) : (Number)0));
        if (stack.size() % 3 == 1) {
            GSKOScriptUtil.tryCalculateIterate(stack);
        }
        return stack.pop();
    }

    public static CompoundNBT get(Stack<CompoundNBT> stack) {
        return GSKOScriptUtil.tryCalculateIterate(stack);
    }

    public static Number tryCalculate(CompoundNBT operationNBT) {
        try {
            Stack<CompoundNBT> result = new Stack<CompoundNBT>();
            Stack<CompoundNBT> stack = GSKOScriptUtil.traverseOpt(operationNBT, BinaryOperation.NONE, result);
            CompoundNBT left = stack.pop();
            CompoundNBT opt = stack.pop();
            CompoundNBT right = stack.pop();
            return GSKONBTUtil.isNumberType(left) && GSKONBTUtil.isNumberType(right) ? (Number)GSKOScriptUtil.calculateNumber(left, BinaryOperation.valueOf(opt.func_74779_i("operation")), right) : (Number)0;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Number calculateNumber(CompoundNBT left, BinaryOperation operation, CompoundNBT right) {
        switch (operation) {
            default: {
                return 0;
            }
            case PLUS: {
                return GSKOScriptUtil.plusIf(left, right);
            }
            case SUBTRACT: {
                return GSKOScriptUtil.subtractIf(left, right);
            }
            case MULTIPLE: {
                return GSKOScriptUtil.mulIf(left, right);
            }
            case DIVIDE: {
                return GSKOScriptUtil.divIf(left, right);
            }
            case MODULUS: 
        }
        return GSKOScriptUtil.modIf(left, right);
    }

    public static CompoundNBT putIf(CompoundNBT nbt, Number number) {
        CompoundNBT compound = new CompoundNBT();
        if (GSKOScriptUtil.isType(nbt, "int")) {
            compound.func_74768_a("value", ((Integer)number).intValue());
        }
        if (GSKOScriptUtil.isType(nbt, "long")) {
            compound.func_74772_a("value", (long)((Integer)number).intValue());
        }
        if (GSKOScriptUtil.isType(nbt, "float")) {
            compound.func_74776_a("value", (float)((Integer)number).intValue());
        }
        if (GSKOScriptUtil.isType(nbt, "double")) {
            compound.func_74780_a("value", (double)((Integer)number).intValue());
        }
        return compound;
    }

    public static Number plusIf(CompoundNBT left, CompoundNBT right) {
        if (left.func_74779_i("type").equals("int") && left.func_74779_i("type").equals("int")) {
            return GSKOScriptUtil.getAsInt(left) + GSKOScriptUtil.getAsInt(right);
        }
        if (left.func_74779_i("type").equals("float") || left.func_74779_i("type").equals("float")) {
            return Float.valueOf(GSKOScriptUtil.getAsFloat(left) + GSKOScriptUtil.getAsFloat(right));
        }
        if (left.func_74779_i("type").equals("double") && left.func_74779_i("type").equals("double")) {
            return GSKOScriptUtil.getAsDouble(left) + GSKOScriptUtil.getAsDouble(right);
        }
        if (left.func_74779_i("type").equals("long") || left.func_74779_i("type").equals("long")) {
            return GSKOScriptUtil.getAsLong(left) + GSKOScriptUtil.getAsLong(right);
        }
        return 0;
    }

    public static Number subtractIf(CompoundNBT left, CompoundNBT right) {
        if (left.func_74779_i("type").equals("int") && left.func_74779_i("type").equals("int")) {
            return GSKOScriptUtil.getAsInt(left) - GSKOScriptUtil.getAsInt(right);
        }
        if (left.func_74779_i("type").equals("float") || left.func_74779_i("type").equals("float")) {
            return Float.valueOf(GSKOScriptUtil.getAsFloat(left) - GSKOScriptUtil.getAsFloat(right));
        }
        if (left.func_74779_i("type").equals("double") && left.func_74779_i("type").equals("double")) {
            return GSKOScriptUtil.getAsDouble(left) - GSKOScriptUtil.getAsDouble(right);
        }
        if (left.func_74779_i("type").equals("long") || left.func_74779_i("type").equals("long")) {
            return GSKOScriptUtil.getAsLong(left) - GSKOScriptUtil.getAsLong(right);
        }
        return 0;
    }

    public static Number mulIf(CompoundNBT left, CompoundNBT right) {
        if (left.func_74779_i("type").equals("int") && left.func_74779_i("type").equals("int")) {
            return GSKOScriptUtil.getAsInt(left) * GSKOScriptUtil.getAsInt(right);
        }
        if (left.func_74779_i("type").equals("float") || left.func_74779_i("type").equals("float")) {
            return Float.valueOf(GSKOScriptUtil.getAsFloat(left) * GSKOScriptUtil.getAsFloat(right));
        }
        if (left.func_74779_i("type").equals("double") && left.func_74779_i("type").equals("double")) {
            return GSKOScriptUtil.getAsDouble(left) * GSKOScriptUtil.getAsDouble(right);
        }
        if (left.func_74779_i("type").equals("long") || left.func_74779_i("type").equals("long")) {
            return GSKOScriptUtil.getAsLong(left) * GSKOScriptUtil.getAsLong(right);
        }
        return 0;
    }

    public static Number divIf(CompoundNBT left, CompoundNBT right) {
        if (left.func_74779_i("type").equals("int") && left.func_74779_i("type").equals("int")) {
            return GSKOScriptUtil.getAsInt(left) / GSKOScriptUtil.getAsInt(right);
        }
        if (left.func_74779_i("type").equals("float") || left.func_74779_i("type").equals("float")) {
            return Float.valueOf(GSKOScriptUtil.getAsFloat(left) / GSKOScriptUtil.getAsFloat(right));
        }
        if (left.func_74779_i("type").equals("double") && left.func_74779_i("type").equals("double")) {
            return GSKOScriptUtil.getAsDouble(left) / GSKOScriptUtil.getAsDouble(right);
        }
        if (left.func_74779_i("type").equals("long") || left.func_74779_i("type").equals("long")) {
            return GSKOScriptUtil.getAsLong(left) / GSKOScriptUtil.getAsLong(right);
        }
        return 0;
    }

    public static Number modIf(CompoundNBT left, CompoundNBT right) {
        if (left.func_74779_i("type").equals("int") && left.func_74779_i("type").equals("int")) {
            return GSKOScriptUtil.getAsInt(left) % GSKOScriptUtil.getAsInt(right);
        }
        if (left.func_74779_i("type").equals("float") || left.func_74779_i("type").equals("float")) {
            return Float.valueOf(GSKOScriptUtil.getAsFloat(left) % GSKOScriptUtil.getAsFloat(right));
        }
        if (left.func_74779_i("type").equals("double") && left.func_74779_i("type").equals("double")) {
            return GSKOScriptUtil.getAsDouble(left) % GSKOScriptUtil.getAsDouble(right);
        }
        if (left.func_74779_i("type").equals("long") || left.func_74779_i("type").equals("long")) {
            return GSKOScriptUtil.getAsLong(left) % GSKOScriptUtil.getAsLong(right);
        }
        return 0;
    }

    public static float getAsFloat(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof IntNBT) {
            return nbt.func_74762_e("value");
        }
        if (nbt.func_74781_a("value") instanceof LongNBT) {
            return nbt.func_74763_f("value");
        }
        if (nbt.func_74781_a("value") instanceof FloatNBT) {
            return nbt.func_74760_g("value");
        }
        if (nbt.func_74781_a("value") instanceof DoubleNBT) {
            return (float)nbt.func_74769_h("value");
        }
        return 0.0f;
    }

    public static int getAsInt(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof IntNBT) {
            return nbt.func_74762_e("value");
        }
        if (nbt.func_74781_a("value") instanceof LongNBT) {
            return (int)nbt.func_74763_f("value");
        }
        if (nbt.func_74781_a("value") instanceof FloatNBT) {
            return (int)nbt.func_74760_g("value");
        }
        if (nbt.func_74781_a("value") instanceof DoubleNBT) {
            return (int)nbt.func_74769_h("value");
        }
        return 0;
    }

    public static long getAsLong(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof IntNBT) {
            return nbt.func_74762_e("value");
        }
        if (nbt.func_74781_a("value") instanceof LongNBT) {
            return nbt.func_74763_f("value");
        }
        if (nbt.func_74781_a("value") instanceof FloatNBT) {
            return (long)nbt.func_74760_g("value");
        }
        if (nbt.func_74781_a("value") instanceof DoubleNBT) {
            return (long)nbt.func_74769_h("value");
        }
        return 0L;
    }

    private static boolean isType(CompoundNBT nbt, String typeStr) {
        return nbt.func_74764_b("type") && nbt.func_74779_i("type").equals(typeStr);
    }

    public static double getAsDouble(CompoundNBT nbt) {
        if (nbt.func_74781_a("value") instanceof IntNBT) {
            return nbt.func_74762_e("value");
        }
        if (nbt.func_74781_a("value") instanceof LongNBT) {
            return nbt.func_74763_f("value");
        }
        if (nbt.func_74781_a("value") instanceof FloatNBT) {
            return nbt.func_74760_g("value");
        }
        if (nbt.func_74781_a("value") instanceof DoubleNBT) {
            return nbt.func_74769_h("value");
        }
        return 0.0;
    }

    public static Vector3d calculateV3d(CompoundNBT left, BinaryOperation operation, CompoundNBT right) {
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public static CompoundNBT getScriptValue(CompoundNBT operationNBT) {
        INBT inbt = GSKONBTUtil.getFromKey(operationNBT, "value");
        if (inbt instanceof CompoundNBT) {
            return (CompoundNBT)inbt;
        }
        return new CompoundNBT();
    }

    public static CompoundNBT getOptLeft(CompoundNBT operationNBT) {
        INBT left;
        if (GSKOScriptUtil.getScriptValue(operationNBT).func_74764_b("left") && (left = GSKONBTUtil.getFromKey(GSKOScriptUtil.getScriptValue(operationNBT), "left")) instanceof CompoundNBT) {
            return (CompoundNBT)left;
        }
        return new CompoundNBT();
    }

    public static CompoundNBT getOptRight(CompoundNBT operationNBT) {
        INBT left;
        if (GSKOScriptUtil.getScriptValue(operationNBT).func_74764_b("right") && (left = GSKONBTUtil.getFromKey(GSKOScriptUtil.getScriptValue(operationNBT), "right")) instanceof CompoundNBT) {
            return (CompoundNBT)left;
        }
        return new CompoundNBT();
    }
}

