/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.network.packet;

import github.thelawf.gensokyoontology.common.container.SpellCardConsoleContainer;
import github.thelawf.gensokyoontology.common.tileentity.SpellConsoleTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CAddScriptPacket {
    public static CAddScriptPacket fromBytes(PacketBuffer buf) {
        return new CAddScriptPacket();
    }

    public void toBytes(PacketBuffer buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CAddScriptPacket.addScript(((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    public static void addScript(ServerPlayerEntity serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        if (!(serverPlayer.field_71070_bA instanceof SpellCardConsoleContainer)) {
            return;
        }
        SpellCardConsoleContainer container = (SpellCardConsoleContainer)serverPlayer.field_71070_bA;
        TileEntity tileEntity = container.getTileEntity();
        if (tileEntity instanceof SpellConsoleTileEntity) {
            SpellConsoleTileEntity spellConsole = (SpellConsoleTileEntity)tileEntity;
            CompoundNBT scriptData = new CompoundNBT();
            ListNBT scriptList = new ListNBT();
            spellConsole.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots() - 1; ++i) {
                    if (!CAddScriptPacket.isAllowedStack(i, itemHandler)) continue;
                    scriptList.add((Object)CAddScriptPacket.getTag(i, itemHandler));
                }
            });
            scriptData.func_218657_a("scripts", (INBT)scriptList);
            container.getOutputStack().func_77982_d(scriptData);
        }
    }

    private static boolean isAllowedStack(int index, IItemHandler itemHandler) {
        return !itemHandler.getStackInSlot(index).func_190926_b();
    }

    private static boolean hasAllowedTag(int index, IItemHandler itemHandler) {
        CompoundNBT nbt = CAddScriptPacket.getTag(index, itemHandler);
        return nbt.func_74764_b("type") && nbt.func_74764_b("value");
    }

    private static CompoundNBT getTag(int index, IItemHandler itemHandler) {
        return itemHandler.getStackInSlot(index).func_77978_p();
    }

    private static ItemStack getOutputStack(IItemHandler itemHandler) {
        return itemHandler.getStackInSlot(itemHandler.getSlots() - 1);
    }
}

