/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.network.packet;

import github.thelawf.gensokyoontology.common.container.script.StaticInvokerContainer;
import github.thelawf.gensokyoontology.common.container.script.V3dInvokerContainer;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CInvokeFunctionPacket {
    private final CompoundNBT invokerData;

    public CInvokeFunctionPacket(CompoundNBT invokerData) {
        this.invokerData = invokerData;
    }

    public static CInvokeFunctionPacket fromBytes(PacketBuffer buf) {
        return new CInvokeFunctionPacket(buf.func_150793_b());
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(this.invokerData);
    }

    public static void handle(CInvokeFunctionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer == null) {
                return;
            }
            switch (packet.invokerData.func_74779_i("type")) {
                case "vector3d_invoker": {
                    CInvokeFunctionPacket.saveV3dFuncData(packet, serverPlayer);
                    break;
                }
                case "static_invoker": {
                    CInvokeFunctionPacket.saveStaticFuncData(packet, serverPlayer);
                    break;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void saveV3dFuncData(CInvokeFunctionPacket packet, ServerPlayerEntity serverPlayer) {
        if (!(serverPlayer.field_71070_bA instanceof V3dInvokerContainer)) {
            return;
        }
        V3dInvokerContainer container = (V3dInvokerContainer)serverPlayer.field_71070_bA;
        ListNBT paramsNBT = new ListNBT();
        if (CInvokeFunctionPacket.checkNotEmpty(container.inventory)) {
            paramsNBT.add((Object)container.inventory.func_70301_a(1).func_77978_p());
        }
    }

    private static void saveStaticFuncData(CInvokeFunctionPacket packet, ServerPlayerEntity serverPlayer) {
        if (!(serverPlayer.field_71070_bA instanceof StaticInvokerContainer)) {
            return;
        }
        StaticInvokerContainer container = (StaticInvokerContainer)serverPlayer.field_71070_bA;
        ListNBT paramsNBT = new ListNBT();
        for (int i = 0; i < container.paramSlots.func_70302_i_(); ++i) {
            CompoundNBT nbt;
            if (container.paramSlots.func_70301_a(i) == ItemStack.field_190927_a || (nbt = container.paramSlots.func_70301_a(i).func_77978_p()) == null) continue;
            paramsNBT.add((Object)nbt);
        }
        packet.invokerData.func_218657_a("parameters", (INBT)paramsNBT);
        if (container.getOutputStack().func_77973_b() == ItemRegistry.STATIC_INVOKER.get()) {
            container.getOutputStack().func_77982_d(packet.invokerData);
        }
    }

    private static boolean checkNotEmpty(IInventory inventory) {
        boolean flag = false;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }
}

