/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.network.packet;

import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPowerChangedPacket {
    private float count;

    public CPowerChangedPacket(float count) {
        this.count = count;
    }

    public static CPowerChangedPacket fromBytes(PacketBuffer buf) {
        return new CPowerChangedPacket(buf.readFloat());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFloat(this.count);
    }

    public static void handle(CPowerChangedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> CPowerChangedPacket.sendToClient(packet));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendToClient(CPowerChangedPacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            GSKOPowerCapability.INSTANCE.setCount(packet.getCount());
        }
    }

    private static void sendToServer(ServerWorld serverWorld, CPowerChangedPacket packet) {
        serverWorld.getCapability(GSKOCapabilities.POWER).ifPresent(gskoCap -> gskoCap.setCount(packet.getCount()));
    }

    public float getCount() {
        return this.count;
    }

    public String toString() {
        return "Power Packet Has: " + this.count;
    }
}

