/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.network.packet;

import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class SLifeTickPacket {
    private long lifetime;

    public SLifeTickPacket(long lifetime) {
        this.lifetime = lifetime;
    }

    public static SLifeTickPacket fromBytes(PacketBuffer buf) {
        return new SLifeTickPacket(buf.readLong());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.lifetime);
    }

    public static void handle(SLifeTickPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> SLifeTickPacket.update(packet));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void update(SLifeTickPacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            mc.field_71439_g.getCapability(GSKOCapabilities.SECULAR_LIFE).ifPresent(cap -> {
                cap.setLifetime(packet.getLifetime());
                LogManager.getLogger().info("[Server] Player Life: {}", (Object)cap.getLifetime());
            });
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }
}

