/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.network.packet;

import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.util.GSKOUtil;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPowerChangedPacket {
    private float count;

    public SPowerChangedPacket(float count) {
        GSKOUtil.log(SPowerChangedPacket.class, count);
        this.count = count;
    }

    public static SPowerChangedPacket fromBytes(PacketBuffer buf) {
        return new SPowerChangedPacket(buf.readFloat());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFloat(this.count);
    }

    public static void handle(SPowerChangedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
                if (serverPlayer != null) {
                    SPowerChangedPacket.handleOnServer(serverPlayer.func_71121_q(), packet);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static void handleOnServer(ServerWorld serverWorld, SPowerChangedPacket packet) {
        serverWorld.getCapability(GSKOCapabilities.POWER).ifPresent(gskoCap -> gskoCap.setCount(packet.getCount()));
    }

    public float getCount() {
        return this.count;
    }
}

