/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import github.thelawf.gensokyoontology.common.particle.GSKOParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class SpaceFissureParticleData
implements IParticleData {
    private final Vector3d speed;
    private final Color color;
    private final float diameter;
    public static final IParticleData.IDeserializer<SpaceFissureParticleData> DESERIALIZER = new IParticleData.IDeserializer<SpaceFissureParticleData>(){

        @Nonnull
        public SpaceFissureParticleData deserialize(@Nonnull ParticleType<SpaceFissureParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            reader.expect(' ');
            double speedX = reader.readDouble();
            reader.expect(' ');
            double speedY = reader.readDouble();
            reader.expect(' ');
            double speedZ = reader.readDouble();
            reader.expect(' ');
            int red = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int alpha = MathHelper.func_76125_a((int)reader.readInt(), (int)1, (int)255);
            reader.expect(' ');
            float diameter = reader.readFloat();
            return new SpaceFissureParticleData(new Vector3d(speedX, speedY, speedZ), new Color(red, green, blue, alpha), diameter);
        }

        @Nonnull
        public SpaceFissureParticleData read(ParticleType<SpaceFissureParticleData> particleTypeIn, PacketBuffer buffer) {
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            double speedX = buffer.readDouble();
            double speedY = buffer.readDouble();
            double speedZ = buffer.readDouble();
            int red = MathHelper.func_76125_a((int)buffer.readInt(), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)buffer.readInt(), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)buffer.readInt(), (int)0, (int)255);
            int alpha = MathHelper.func_76125_a((int)buffer.readInt(), (int)1, (int)255);
            float diameter = buffer.readFloat();
            return new SpaceFissureParticleData(new Vector3d(speedX, speedY, speedZ), new Color(red, green, blue, alpha), diameter);
        }
    };

    public SpaceFissureParticleData(Vector3d speed, Color color, float diameter) {
        this.speed = speed;
        this.color = color;
        this.diameter = diameter;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeDouble(this.speed.field_72450_a);
        buffer.writeDouble(this.speed.field_72448_b);
        buffer.writeDouble(this.speed.field_72449_c);
        buffer.writeInt(this.color.getRed());
        buffer.writeInt(this.color.getGreen());
        buffer.writeInt(this.color.getBlue());
        buffer.writeInt(this.color.getAlpha());
        buffer.writeFloat(this.diameter);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %d %d %d %d %.2f %.2f %.2f", this.func_197554_b().getRegistryName(), Float.valueOf(this.diameter), this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha(), this.speed.func_82615_a(), this.speed.func_82617_b(), this.speed.func_82616_c());
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return (ParticleType)GSKOParticleRegistry.SPACE_FISSURE.get();
    }

    public Vector3d getSpeed() {
        return this.speed;
    }

    public Color getColor() {
        return this.color;
    }

    public float getDiameter() {
        return this.diameter;
    }
}

