/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import github.thelawf.gensokyoontology.common.container.DanmakuCraftingContainer;
import github.thelawf.gensokyoontology.core.RecipeRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DanmakuTabelTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> optionalHandler = LazyOptional.of(() -> this.itemHandler);
    public static final TranslationTextComponent CONTAINER_NAME = new TranslationTextComponent("container.gensokyoontology.danmaku_craft.title");

    public DanmakuTabelTileEntity() {
        super((TileEntityType)TileEntityRegistry.DANMAKU_TABLE_TILE.get());
    }

    public static INamedContainerProvider createContainer(World worldIn, BlockPos posIn) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return CONTAINER_NAME;
            }

            @Nullable
            public Container createMenu(int winwdowId, PlayerInventory playerInventory, PlayerEntity player) {
                return new DanmakuCraftingContainer(winwdowId, playerInventory);
            }
        };
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        super.func_230337_a_(state, nbt);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(29){

            protected void onContentsChanged(int slot) {
                DanmakuTabelTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 25) {
                    return stack.func_77973_b() == ItemRegistry.DANMAKU_SHOT.get();
                }
                return super.isItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                if (slot >= 0 && slot < 25) {
                    return 1;
                }
                return super.getSlotLimit(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.optionalHandler.cast();
        }
        return super.getCapability(cap);
    }

    public void checkCraft() {
        this.func_70296_d();
    }

    private void craft(World world, CraftingInventory inventory, CraftResultInventory inventoryResult) {
        if (!world.field_72995_K) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(RecipeRegistry.DANMAKU_RECIPE, (IInventory)inventory, world);
            if (optional.isPresent()) {
                ICraftingRecipe icraftingrecipe = (ICraftingRecipe)optional.get();
                itemstack = icraftingrecipe.func_77572_b((IInventory)inventory);
            }
            inventoryResult.func_70299_a(0, itemstack);
        }
    }

    public void func_73660_a() {
        this.checkCraft();
    }
}

