/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class DisposableSpawnerTile
extends TileEntity
implements ITickableTileEntity,
IRayTraceReader {
    private EntityType<?> entityType = (EntityType)EntityRegistry.FLANDRE_SCARLET.get();
    private boolean canContinueSpawn = true;

    public DisposableSpawnerTile() {
        super((TileEntityType)TileEntityRegistry.DISPOSABLE_SPAWNER_TILE_ENTITY.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_145850_b instanceof ServerWorld) {
            PlayerEntity player = this.field_145850_b.func_217366_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 60.0, false);
            if (player == null) {
                return;
            }
            Predicate<DisposableSpawnerTile> predicate = tileEntity -> tileEntity.getSpawnEntity() != null && !player.func_184812_l_();
            this.spawn(predicate, player);
            this.func_70296_d();
        }
    }

    private void spawn(Predicate<DisposableSpawnerTile> predicate, PlayerEntity triggeredPlayer) {
        if (this.getSpawnEntity() != null && !triggeredPlayer.func_184812_l_() && this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            CompoundNBT compound = this.func_189515_b(new CompoundNBT());
            BlockPos.Mutable blockPos = this.field_174879_c.func_239590_i_().func_196234_d(GSKOMathUtil.randomRange(-3, 3), 1, GSKOMathUtil.randomRange(-3, 3));
            Optional optionalEntity = EntityType.func_220347_a((CompoundNBT)compound);
            optionalEntity.ifPresent(type -> type.func_220331_a(serverWorld, null, null, blockPos.func_185334_h(), SpawnReason.SPAWNER, false, false));
            this.canContinueSpawn = false;
            this.func_70296_d();
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void setEntityType(EntityType<?> entityTypeIn) {
        this.entityType = entityTypeIn;
        this.func_70296_d();
    }

    public EntityType<?> getSpawnEntity() {
        return this.entityType;
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        Optional entityOptional = EntityType.func_220347_a((CompoundNBT)nbt);
        entityOptional.ifPresent(type -> {
            this.entityType = (EntityType)entityOptional.get();
        });
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("id", this.getSpawnEntity().getRegistryName() == null ? GensokyoOntology.withRL("flandre_scarlet").toString() : this.getSpawnEntity().getRegistryName().toString());
        compound.func_74757_a("can_continue_spawn", this.canContinueSpawn);
        return compound;
    }
}

