/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import github.thelawf.gensokyoontology.common.util.world.GSKOWorldUtil;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GapTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int MAX_COOLDOWN_TICK = 400;
    private boolean allowTeleport = false;
    private BlockPos destinationPos;
    private RegistryKey<World> destinationWorld;
    private int cooldown = 0;

    public GapTileEntity(RegistryKey<World> destinationWorld, BlockPos destinationPos) {
        super((TileEntityType)TileEntityRegistry.GAP_TILE_ENTITY.get());
        this.setDestinationWorld(destinationWorld);
        this.setDestinationPos(destinationPos);
    }

    public GapTileEntity() {
        super((TileEntityType)TileEntityRegistry.GAP_TILE_ENTITY.get());
        this.setDestinationWorld((RegistryKey<World>)World.field_234918_g_);
        this.setDestinationPos(BlockPos.field_177992_a);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return super.func_189517_E_();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return super.func_189518_D_();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        if (nbt.func_74764_b("DestinationX") && nbt.func_74764_b("DestinationY") && nbt.func_74764_b("DestinationZ")) {
            this.destinationPos = new BlockPos(nbt.func_74762_e("DestinationX"), nbt.func_74762_e("DestinationY"), nbt.func_74762_e("DestinationZ"));
        }
        if (nbt.func_74764_b("DestinationWorld")) {
            this.destinationWorld = GSKOWorldUtil.getWorldDimension(new ResourceLocation(nbt.func_74779_i("DestinationWorld")));
        }
        if (nbt.func_74764_b("AllowTeleport")) {
            this.allowTeleport = nbt.func_74767_n("AllowTeleport");
        }
        if (nbt.func_74764_b("Cooldown")) {
            this.setCooldown(nbt.func_74762_e("Cooldown"));
        }
        super.func_230337_a_(state, nbt);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("DestinationWorld", this.destinationWorld.func_240901_a_().toString());
        compound.func_74757_a("AllowTeleport", this.allowTeleport);
        compound.func_74768_a("Cooldown", this.cooldown);
        compound.func_74768_a("DestinationX", this.destinationPos.func_177958_n());
        compound.func_74768_a("DestinationY", this.destinationPos.func_177956_o());
        compound.func_74768_a("DestinationZ", this.destinationPos.func_177952_p());
        return compound;
    }

    public void setDestinationPos(BlockPos destinationPos) {
        this.destinationPos = destinationPos;
        this.func_70296_d();
    }

    public void setDestinationWorld(RegistryKey<World> destinationWorld) {
        this.destinationWorld = destinationWorld;
        this.allowTeleport = true;
        this.func_70296_d();
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.func_70296_d();
    }

    public BlockPos getDestinationPos() {
        return this.destinationPos;
    }

    public RegistryKey<World> getDestinationWorld() {
        return this.destinationWorld;
    }

    public boolean isAllowTeleport() {
        return this.allowTeleport;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setAllowTeleport(boolean isAllowTeleport) {
        this.allowTeleport = isAllowTeleport;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
                this.func_70296_d();
            } else {
                ++this.cooldown;
                this.func_70296_d();
            }
        }
    }
}

