/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.util.BlessType;
import github.thelawf.gensokyoontology.core.init.EffectRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class SaisenBoxTileEntity
extends TileEntity
implements ITickableTileEntity,
IRayTraceReader {
    private int count;
    private UUID ownerId;
    private UUID throwerId;
    public int ticks = 0;
    private static final List<Pair<Integer, BlessType>> BLESS_LIST = ImmutableList.of((Object)Pair.of((Object)50, (Object)((Object)BlessType.IMMUNE_POISON)), (Object)Pair.of((Object)100, (Object)((Object)BlessType.IMMUNE_BLOODY_MIST)));

    public SaisenBoxTileEntity() {
        super((TileEntityType)TileEntityRegistry.SAISEN_BOX_TILE_ENTITY.get());
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        if (nbt.func_74764_b("count")) {
            this.count = nbt.func_74762_e("count");
        }
        super.func_230337_a_(state, nbt);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("count", this.count);
        return compound;
    }

    public void func_73660_a() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v().func_177984_a());
        if (this.field_145850_b != null) {
            List<ItemEntity> itemEntities = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, EntityPredicates.field_94557_a).stream().filter(itemEntity -> itemEntity.func_92059_d().func_77973_b() == ItemRegistry.SILVER_COIN.get()).collect(Collectors.toList());
            itemEntities.forEach(this::tryApplyBless);
            this.addCoinCount(itemEntities.size());
            this.func_70296_d();
        }
        ++this.ticks;
    }

    public void addCoinCount(int count) {
        this.count += count;
    }

    private void tryApplyBless(ItemEntity itemEntity) {
        if (itemEntity.func_200214_m() == null || !(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        if (serverWorld.func_217461_a(itemEntity.func_200214_m()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)serverWorld.func_217461_a(itemEntity.func_200214_m());
            if (player == null) {
                return;
            }
            this.testCount(player);
            itemEntity.func_92059_d().func_190918_g(itemEntity.func_92059_d().func_190916_E());
        }
    }

    public int getCount() {
        return this.count;
    }

    public void testCount(PlayerEntity player) {
        for (int i = 0; i < BLESS_LIST.size(); ++i) {
            if (this.getCount() < (Integer)BLESS_LIST.get(i).getFirst()) continue;
            int duration = 6000 + 500 * i;
            player.func_195064_c(new EffectInstance((Effect)EffectRegistry.HAKUREI_BLESS_EFFECT.get(), duration, i));
            return;
        }
    }
}

