/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import github.thelawf.gensokyoontology.common.container.SorceryExtractorContainer;
import github.thelawf.gensokyoontology.core.RecipeRegistry;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import github.thelawf.gensokyoontology.data.recipe.SorceryExtractorRecipe;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SorceryExtractorTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final int slotCount = 5;
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> optionalHandler = LazyOptional.of(() -> this.itemHandler);
    public static final TranslationTextComponent CONTAINER_NAME = new TranslationTextComponent("container.gensokyoontology.sorcery_extractor.title");

    public SorceryExtractorTileEntity() {
        super((TileEntityType)TileEntityRegistry.SORCERY_EXTRACTOR_TILE_ENTITY.get());
    }

    public static INamedContainerProvider createContainer(final World worldIn, final BlockPos posIn) {
        return new INamedContainerProvider(){

            @NotNull
            public ITextComponent func_145748_c_() {
                return CONTAINER_NAME;
            }

            public Container createMenu(int windowId, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity player) {
                return new SorceryExtractorContainer(windowId, worldIn, posIn, playerInventory);
            }
        };
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        super.func_230337_a_(state, nbt);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                SorceryExtractorTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                if (slot >= 0 && slot < 25) {
                    return 1;
                }
                return super.getSlotLimit(slot);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.optionalHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void checkCraft() {
        Inventory inv = new Inventory(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
            inv.func_70299_a(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeRegistry.SORCERY_RECIPE, (IInventory)inv, this.field_145850_b);
        recipe.ifPresent(this::doCraft);
    }

    public void doCraft(SorceryExtractorRecipe recipe) {
        this.itemHandler.insertItem(4, recipe.func_77571_b(), false);
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        this.checkCraft();
    }
}

