/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.tileentity;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.container.SpellCardConsoleContainer;
import github.thelawf.gensokyoontology.common.item.script.DynamicScriptItem;
import github.thelawf.gensokyoontology.common.item.script.ScriptBuilderItem;
import github.thelawf.gensokyoontology.common.item.script.ScriptReadOnlyItem;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import github.thelawf.gensokyoontology.core.init.TileEntityRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellConsoleTileEntity
extends TileEntity
implements ITickableTileEntity {
    public final int slotCount = 31;
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> optionalHandler = LazyOptional.of(() -> this.itemHandler);
    public static final TranslationTextComponent CONTAINER_NAME = GensokyoOntology.withTranslation("container.", ".spell_card_console.title");

    public SpellConsoleTileEntity() {
        super((TileEntityType)TileEntityRegistry.SPELL_CONSOLE_TILE_ENTITY.get());
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        super.func_230337_a_(state, nbt);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                SpellConsoleTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == this.getSlots() - 1) {
                    return stack.func_77973_b() == ItemRegistry.SCRIPTED_SPELL_CARD.get();
                }
                return stack.func_77973_b() instanceof ScriptReadOnlyItem || stack.func_77973_b() instanceof DynamicScriptItem || stack.func_77973_b() instanceof ScriptBuilderItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static INamedContainerProvider create(final World worldIn, final BlockPos posIn) {
        return new INamedContainerProvider(){

            @NotNull
            public ITextComponent func_145748_c_() {
                return CONTAINER_NAME;
            }

            @NotNull
            public Container createMenu(int windowsId, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity player) {
                return new SpellCardConsoleContainer(windowsId, player, worldIn, posIn);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.optionalHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
    }

    public boolean isAllowedItem(int index, IItemHandler itemHandler) {
        return itemHandler.isItemValid(index, itemHandler.getStackInSlot(index));
    }

    public boolean hasAllowedTag(int index, IItemHandler itemHandler) {
        CompoundNBT nbt = this.getTag(index, itemHandler);
        return nbt.func_150296_c().contains("type") && nbt.func_150296_c().contains("value") || nbt.func_150296_c().contains("name");
    }

    public CompoundNBT getTag(int index, IItemHandler itemHandler) {
        return itemHandler.getStackInSlot(index).func_77978_p();
    }

    public ItemStack getOutputStack(IItemHandler itemHandler) {
        return itemHandler.getStackInSlot(itemHandler.getSlots() - 1);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

