/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ReflectHelper {
    public static <D extends GenericDeclaration> boolean areTypeParametersEqual(Class<?> objClass, Class<?> ... typeClasses) {
        int match = 0;
        for (TypeVariable<Class<?>> variable : objClass.getTypeParameters()) {
            for (Class<?> typeClass : typeClasses) {
                match += variable.getClass().getName().equals(typeClass.getName()) ? 1 : 0;
            }
        }
        return match == objClass.getTypeParameters().length;
    }

    public static <O, G> boolean isTypeEqual(Field field, Class<O> objClass, Class<G> genericClass) {
        Type[] typeArguments;
        Type genericType;
        return field.getType() == objClass && (genericType = field.getGenericType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && typeArguments[0] == genericClass;
    }

    public static <T> Object getPublicStatic(T t, String name) throws IllegalAccessException {
        Optional<Field> optional = Stream.of(t.getClass().getDeclaredFields()).filter(field -> {
            int modifiers = field.getModifiers();
            boolean flag = Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
            return flag && field.getName().equals(name);
        }).findAny();
        if (optional.isPresent()) {
            return optional.get().get(t);
        }
        return null;
    }

    public static <T> Object getFieldValue(Class<T> clazz, String fieldName, Object target) {
        try {
            return ObfuscationReflectionHelper.findField(clazz, (String)fieldName).get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setFieldValue(Class<T> clazz, String fieldName, Object target, Object value) {
        try {
            Field field = ObfuscationReflectionHelper.findField(clazz, (String)fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

