/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.danmaku;

import github.thelawf.gensokyoontology.GensokyoOntology;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;

public enum DanmakuType {
    DANMAKU_SHOT("danmaku_shot", 0.5f, 0.1f, new Effect[0]),
    LARGE_SHOT("large_shot", 2.5f, 5.5f, new Effect[0]),
    SMALL_SHOT("small_shot", 0.5f, 2.0f, new Effect[0]),
    STAR_SHOT_LARGE("large_star_shot", 1.5f, 3.0f, new Effect[0]),
    STAR_SHOT_SMALL("small_star_shot", 0.5f, 0.5f, new Effect[0]),
    RICE_SHOT("rice_shot", 0.5f, 1.0f, new Effect[0]),
    SCALE_SHOT("scale_shot", 0.5f, 2.0f, new Effect[0]),
    HEART_SHOT("heart_shot", 1.5f, 3.5f, new Effect[0]),
    TALISMAN_SHOT("talisman_shot", 1.0f, 2.5f, new Effect[0]),
    INYO_JADE("inyo_jade", 2.0f, 3.0f, new Effect[0]),
    FAKE_LUNAR("fake_lunar", 5.0f, 12.0f, new Effect[0]),
    CIRCLE_SHOT("circle_shot", 1.0f, 2.0f, new Effect[0]);

    public final String name;
    public final float damage;
    public final float size;
    public final Effect[] effect;

    private DanmakuType(String name, @Nullable float size, float damage, Effect ... effect) {
        this.name = name;
        this.damage = damage;
        this.size = size;
        this.effect = effect;
    }

    public ITextComponent toTextComponent() {
        return GensokyoOntology.withTranslation("gui.", ".danmaku_type." + this.name);
    }

    public DanmakuType getIfMatches(String name) {
        return Objects.equals(name, this.name) ? this : LARGE_SHOT;
    }
}

