/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.danmaku;

import com.google.common.collect.Lists;
import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.TransformFunction;
import github.thelawf.gensokyoontology.common.util.danmaku.VectorOperations;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class DanmakuUtil {
    public static <D extends AbstractDanmakuEntity> List<D> newDanmakuPool(Supplier<D> danmaku, Class<D> danmakuClass, int count) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ArrayList<D> danmakuPool = new ArrayList<D>();
        for (int i = 0; i < count; ++i) {
            Constructor<D> constructor = danmakuClass.getDeclaredConstructor(EntityType.class, World.class, Entity.class, DanmakuType.class, DanmakuColor.class);
            danmakuPool.add(constructor.newInstance(new Object[]{((AbstractDanmakuEntity)((Object)danmaku.get())).func_200600_R(), ((AbstractDanmakuEntity)((Object)danmaku.get())).field_70170_p, ((AbstractDanmakuEntity)((Object)danmaku.get())).getShooter(), ((AbstractDanmakuEntity)((Object)danmaku.get())).getDanmakuType(), ((AbstractDanmakuEntity)((Object)danmaku.get())).getDanmakuColor()}));
        }
        return danmakuPool;
    }

    public static <D extends AbstractDanmakuEntity> AbstractDanmakuEntity newDanmaku(D danmaku, Class<D> danmakuClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<D> constructor = danmakuClass.getDeclaredConstructor(EntityType.class, World.class, Entity.class, DanmakuType.class, DanmakuColor.class);
        return (AbstractDanmakuEntity)((Object)constructor.newInstance(new Object[]{danmaku.func_200600_R(), danmaku.field_70170_p, danmaku.getShooter(), danmaku.getDanmakuType(), danmaku.getDanmakuColor()}));
    }

    public static <D extends AbstractDanmakuEntity> void shootDanmaku(@NotNull World worldIn, PlayerEntity playerIn, D danmakuEntityType, float velocity, float inaccuracy) {
        Vector3d lookVec = playerIn.func_70040_Z();
        danmakuEntityType.func_189654_d(true);
        danmakuEntityType.func_70012_b(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)playerIn.func_70047_e(), playerIn.func_226281_cx_(), (float)lookVec.field_72448_b, (float)lookVec.field_72449_c);
        danmakuEntityType.func_70186_c(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c, velocity, inaccuracy);
        worldIn.func_217376_c(danmakuEntityType);
    }

    public static <D extends AbstractDanmakuEntity> void shootDanmaku(@NotNull World worldIn, Entity entityIn, D danmakuEntityType, Vector3d shootVec, float velocity, float inaccuracy) {
        Vector3d lookVec = entityIn.func_70040_Z();
        danmakuEntityType.func_189654_d(true);
        danmakuEntityType.func_70012_b(entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + (double)entityIn.func_70047_e(), entityIn.func_226281_cx_(), (float)lookVec.field_72448_b, (float)lookVec.field_72449_c);
        danmakuEntityType.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, velocity, inaccuracy);
        worldIn.func_217376_c(danmakuEntityType);
    }

    public static <D extends AbstractDanmakuEntity> void initDanmaku(D danmaku, Vector3d globalPos, Vector2f rotation, boolean noGravity) {
        danmaku.func_189654_d(noGravity);
        danmaku.func_70012_b(globalPos.func_82615_a(), globalPos.func_82617_b(), globalPos.func_82616_c(), rotation.field_189982_i, rotation.field_189983_j);
    }

    public static <D extends AbstractDanmakuEntity> void initDanmaku(D danmaku, Vector3d globalPos, boolean noGravity) {
        danmaku.func_189654_d(noGravity);
        danmaku.func_70012_b(globalPos.func_82615_a(), globalPos.func_82617_b(), globalPos.func_82616_c(), Vector2f.field_189974_a.field_189982_i, Vector2f.field_189974_a.field_189983_j);
    }

    public static void applyOperation(ArrayList<VectorOperations> operations, TransformFunction function, Vector3d prevVec) {
    }

    public static Vector3d getTransform(VectorOperations operation, TransformFunction function, Vector3d prevVec) {
        if (function.scaling > 0.0f) {
            if (operation == VectorOperations.ROTATE_YAW) {
                return prevVec.func_178785_b(function.scaling);
            }
            if (operation == VectorOperations.ROTATE_ROLL) {
                return prevVec.func_242988_c(function.scaling);
            }
            if (operation == VectorOperations.ROTATE_PITCH) {
                return prevVec.func_178789_a(function.scaling);
            }
            if (operation == VectorOperations.VECTOR_SCALE) {
                return prevVec.func_186678_a((double)function.scaling);
            }
        } else if (function.acceleration != null) {
            if (operation == VectorOperations.VECTOR_ADD) {
                return prevVec.func_178787_e(function.acceleration);
            }
            if (operation == VectorOperations.VECTOR_SUBTRACT) {
                return prevVec.func_178788_d(function.acceleration);
            }
        } else if (operation == VectorOperations.ARCHIMEDE_SPIRAL) {
            return DanmakuUtil.getArchimedeSpiral(prevVec, 1.0, Math.PI);
        }
        return prevVec;
    }

    public static Vector3d getArchimedeSpiral(Vector3d prevVec, double radius, double angle) {
        return new Vector3d(prevVec.field_72450_a * radius * Math.cos(angle), prevVec.field_72448_b, prevVec.field_72449_c * radius * Math.signum(angle));
    }

    public static List<Item> getAllDanmakuItem() {
        ArrayList<Item> danmakuItems = new ArrayList<Item>();
        danmakuItems.add((Item)ItemRegistry.LARGE_SHOT_RED.get());
        danmakuItems.add((Item)ItemRegistry.LARGE_SHOT_PURPLE.get());
        danmakuItems.add((Item)ItemRegistry.LARGE_SHOT_BLUE.get());
        danmakuItems.add((Item)ItemRegistry.LARGE_SHOT_GREEN.get());
        danmakuItems.add((Item)ItemRegistry.LARGE_SHOT_YELLOW.get());
        danmakuItems.add((Item)ItemRegistry.SMALL_SHOT_RED.get());
        danmakuItems.add((Item)ItemRegistry.SMALL_SHOT_BLUE.get());
        danmakuItems.add((Item)ItemRegistry.SMALL_SHOT_GREEN.get());
        danmakuItems.add((Item)ItemRegistry.SMALL_SHOT_PURPLE.get());
        danmakuItems.add((Item)ItemRegistry.SMALL_SHOT_YELLOW.get());
        danmakuItems.add((Item)ItemRegistry.HEART_SHOT_RED.get());
        danmakuItems.add((Item)ItemRegistry.HEART_SHOT_PINK.get());
        danmakuItems.add((Item)ItemRegistry.HEART_SHOT_AQUA.get());
        return danmakuItems;
    }

    public static Vector3d rotateRandomAngle(Vector3d preVec, float yawBounds, float pitchBounds) {
        Vector3d nextVec = preVec.func_178785_b(GSKOMathUtil.randomRange(0.0f, yawBounds));
        nextVec = nextVec.func_178789_a(GSKOMathUtil.randomRange(0.0f, pitchBounds));
        return nextVec;
    }

    public static Vector3d getRandomPos(Vector3d center, Vector3f radius) {
        double x = GSKOMathUtil.randomRange(-radius.func_195899_a(), radius.func_195899_a());
        double y = GSKOMathUtil.randomRange(-radius.func_195900_b(), radius.func_195900_b());
        double z = GSKOMathUtil.randomRange(-radius.func_195902_c(), radius.func_195902_c());
        return new Vector3d(center.field_72450_a + x, center.field_72448_b + y, center.field_72449_c + z);
    }

    public static Vector3d getRandomPosWithin(float radius, Plane planeIn) {
        return DanmakuUtil.getRandomPosWithin(new Vector3f(radius, radius, radius), planeIn);
    }

    public static Vector3d getRandomPosWithin(Vector3f radius, Plane planeIn) {
        double x = GSKOMathUtil.randomRange(-radius.func_195899_a(), radius.func_195899_a());
        double y = GSKOMathUtil.randomRange(-radius.func_195900_b(), radius.func_195900_b());
        double z = GSKOMathUtil.randomRange(-radius.func_195902_c(), radius.func_195902_c());
        Vector3d vector3d = Vector3d.field_186680_a;
        switch (planeIn) {
            case XY: {
                vector3d = new Vector3d(x, y, 0.0);
                break;
            }
            case XZ: {
                vector3d = new Vector3d(x, 0.0, z);
                break;
            }
            case YZ: {
                vector3d = new Vector3d(0.0, y, z);
                break;
            }
            case XYZ: {
                vector3d = new Vector3d(x, y, z);
            }
        }
        return vector3d;
    }

    public static Vector3d getAimingShootVec(LivingEntity thrower, LivingEntity target) {
        float offset = (float)((double)0.3f / target.func_70033_W());
        return new Vector3d(target.func_226277_ct_() - thrower.func_226277_ct_(), target.func_226278_cu_() - thrower.func_226278_cu_() - (double)offset, target.func_226281_cx_() - thrower.func_226281_cx_());
    }

    public static <D extends AbstractDanmakuEntity> void shootWithRoseLine(D danmaku, Plane planeIn, Vector3d offsetRotation, double radius, double count, double size, int density) {
    }

    public static List<Vector3d> getRoseLinePos(double radius, double count, double size, double delta) {
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        count /= size;
        for (double i = 0.0; i < Math.PI * 4; i += delta) {
            double r = Math.sin(count * i);
            double x = r * Math.cos(i) * radius;
            double y = r * Math.sin(i) * radius;
            positions.add(new Vector3d((double)((float)x), (double)((float)y), 0.0));
        }
        return positions;
    }

    public static List<Vector3d> getHeartLinePos(float radius, double delta) {
        double t = 0.0;
        double maxT = Math.PI * 2;
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int i = 0;
        while ((double)i < Math.ceil(maxT / delta)) {
            float x = (float)(16.0 * GSKOMathUtil.pow3(Math.sin(t)));
            float y = (float)(13.0 * Math.cos(t) - 5.0 * Math.cos(2.0 * t) - 2.0 * Math.cos(3.0 * t) - Math.cos(4.0 * t));
            t += delta;
            positions.add(new Vector3d((double)(x * radius), (double)(y * radius), 0.0));
            ++i;
        }
        return positions;
    }

    public static List<Vector3d> getStarLinePos(float radius, double t, Plane planeIn) {
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int i = 0;
        while ((double)i < Math.PI * 2) {
            double x = (double)radius * GSKOMathUtil.pow3(Math.cos(t));
            double y = (double)radius * GSKOMathUtil.pow3(Math.sin(t));
            switch (planeIn) {
                case XY: {
                    positions.add(new Vector3d(x, y, 0.0));
                    break;
                }
                default: {
                    positions.add(new Vector3d(x, 0.0, y));
                    break;
                }
                case YZ: {
                    positions.add(new Vector3d(0.0, y, x));
                }
            }
            i = (int)((double)i + t);
        }
        return positions;
    }

    public static List<Vector3d> getRotatedPos(List<Vector3d> prevPositions, float yaw, float pitch) {
        ArrayList<Vector3d> newPos = new ArrayList<Vector3d>();
        for (Vector3d prevPos : prevPositions) {
            newPos.add(prevPos.func_178789_a(pitch).func_178785_b(yaw));
        }
        return newPos;
    }

    public static List<Vector3d> getParaboloidPos(Vector2f range, double a, double b, double delta) {
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int i = 0;
        while ((float)i < range.field_189982_i) {
            int j = 0;
            while ((float)j < range.field_189983_j) {
                double z = GSKOMathUtil.pow2(i) / GSKOMathUtil.pow2(a) - GSKOMathUtil.pow2(j) / GSKOMathUtil.pow2(b);
                positions.add(new Vector3d((double)i, (double)j, z));
                j = (int)((double)j + delta);
            }
            i = (int)((double)i + delta);
        }
        return positions;
    }

    public static List<Vector3d> getEllipticParaboloidPos(Vector2f start, Vector2f end, double a, double b, double delta) {
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        return positions;
    }

    public static List<Vector3d> spheroidPos(double radius, int count) {
        ArrayList<Vector3d> coordinates = new ArrayList<Vector3d>();
        List<Vector3d> pos1 = DanmakuUtil.ellipticPos(new Vector2f(0.0f, 0.0f), radius, count);
        for (int i = 0; i < pos1.size(); ++i) {
            for (int j = 0; j < pos1.size(); ++j) {
                Vector3d vector3d = pos1.get(j).func_178789_a((float)Math.PI * 2 / (float)pos1.size() * (float)j);
                pos1.set(j, vector3d);
            }
            coordinates.addAll(pos1);
        }
        return coordinates;
    }

    public static List<Vector3d> ellipticPos(Vector2f center, double radius, int count) {
        ArrayList<Vector3d> coordinates = new ArrayList<Vector3d>();
        double angleInterval = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double angle = (double)i * angleInterval;
            double x = (double)center.field_189982_i + radius * Math.cos(angle);
            double y = (double)center.field_189983_j + radius * Math.sin(angle);
            coordinates.add(new Vector3d(x, 0.0, y));
        }
        return coordinates;
    }

    public static Vector3d getAimedVec(LivingEntity shooter, LivingEntity target) {
        return target.func_213303_ch().func_178788_d(shooter.func_213303_ch());
    }

    public static List<DanmakuColor> getRainbowColoredDanmaku() {
        return Lists.newArrayList((Object[])new DanmakuColor[]{DanmakuColor.RED, DanmakuColor.ORANGE, DanmakuColor.YELLOW, DanmakuColor.GREEN, DanmakuColor.AQUA, DanmakuColor.BLUE, DanmakuColor.PURPLE, DanmakuColor.MAGENTA});
    }

    public static enum Plane {
        XZ,
        XY,
        YZ,
        XYZ;

    }
}

