/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.danmaku;

import github.thelawf.gensokyoontology.common.util.danmaku.ITransform;
import github.thelawf.gensokyoontology.common.util.danmaku.TransformUnit;
import github.thelawf.gensokyoontology.common.util.danmaku.VectorOperations;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.common.util.math.LineSegment3D;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformFunction
extends ITransform.AbstractTransform {
    public static final Logger LOGGER = LogManager.getLogger();
    private World worldIn;
    private PlayerEntity playerIn;
    public double pivotX;
    public double pivotY;
    public double pivotZ = 0.0;
    public double yaw;
    public double pitch;
    public double roll = 0.0;
    public double x;
    public double y;
    public double z = 0.0;
    public Vector3d initLocation = new Vector3d(0.0, 0.0, 0.0);
    public Vector3d shootVector = new Vector3d(0.0, 0.0, 0.0);
    public int executeTimes = 0;
    public int lifeSpan = 0;
    public double executeInterval = 0.0;
    public UUID aimingAt = null;
    public ArrayList<VectorOperations> transformOrders = new ArrayList();
    public ArrayList<TransformUnit> transformUnits = new ArrayList();
    public VectorOperations vectorOperations;
    public Vector3d speedV3 = new Vector3d(0.0, 0.0, 0.0);
    public Vector3d nextShootVec = new Vector3d(0.0, 0.0, 0.0);
    public double resultantSpeed;
    public double increment = 0.0;
    public float scaling = 0.0f;
    public Vector3d acceleration = new Vector3d(0.0, 0.0, 0.0);
    public Vector3d subtraction = new Vector3d(0.0, 0.0, 0.0);

    public TransformFunction() {
    }

    public TransformFunction(double yaw, double pitch, double roll, double posX, double posY, double posZ) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.resultantSpeed = GSKOMathUtil.toModulus3D(posX, posY, posZ);
    }

    public TransformFunction setAimingAt(UUID aimingAt) {
        this.aimingAt = aimingAt;
        return this;
    }

    public TransformFunction setShootVector(Vector3d shootVector) {
        this.shootVector = shootVector;
        return this;
    }

    public TransformFunction setAcceleration(Vector3d acceleration) {
        this.acceleration = acceleration;
        return this;
    }

    public TransformFunction setExecuteInterval(double executeInterval) {
        this.executeInterval = executeInterval;
        return this;
    }

    public TransformFunction setExecuteTimes(int executeTimes) {
        this.executeTimes = executeTimes;
        return this;
    }

    public TransformFunction setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
        return this;
    }

    public TransformFunction setWorld(World worldIn) {
        this.worldIn = worldIn;
        return this;
    }

    public TransformFunction setScaling(float scaling) {
        this.scaling = scaling;
        return this;
    }

    public TransformFunction setYaw(double yaw) {
        this.yaw = yaw;
        return this;
    }

    public TransformFunction setRoll(double roll) {
        this.roll = roll;
        return this;
    }

    public TransformFunction setPitch(double pitch) {
        this.pitch = pitch;
        return this;
    }

    public TransformFunction setTransformOrders(ArrayList<VectorOperations> transformOrders) {
        this.transformOrders = transformOrders;
        return this;
    }

    public Vector3d increaseYaw(float yawIncrement) {
        float f = MathHelper.func_76134_b((float)yawIncrement);
        float f1 = MathHelper.func_76126_a((float)yawIncrement);
        double d0 = this.x * (double)f + this.z * (double)f1;
        double d1 = this.y;
        double d2 = this.z * (double)f - this.x * (double)f1;
        this.speedV3 = new Vector3d(this.speedV3.field_72450_a + d0, this.speedV3.field_72448_b, this.speedV3.field_72449_c + d2);
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d increasePitch(float pitchIncrement) {
        float f = MathHelper.func_76134_b((float)pitchIncrement);
        float f1 = MathHelper.func_76126_a((float)pitchIncrement);
        double d0 = this.x;
        double d1 = this.y * (double)f + this.z * (double)f1;
        double d2 = this.z * (double)f - this.y * (double)f1;
        this.speedV3 = new Vector3d(this.speedV3.field_72450_a, this.speedV3.field_72448_b + d1, this.speedV3.field_72449_c + d2);
        return new Vector3d(d0, d1, d2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d increaseRoll(float rollIncrement) {
        float f = MathHelper.func_76134_b((float)rollIncrement);
        float f1 = MathHelper.func_76126_a((float)rollIncrement);
        double d0 = this.x * (double)f + this.y * (double)f1;
        double d1 = this.y * (double)f - this.x * (double)f1;
        double d2 = this.z;
        this.speedV3 = new Vector3d(this.speedV3.field_72450_a + d0, this.speedV3.field_72448_b + d1, this.speedV3.field_72449_c);
        return new Vector3d(d0, d1, d2);
    }

    public TransformFunction setInitLocation(Vector3d initLocation) {
        this.initLocation = initLocation;
        this.x = initLocation.field_72450_a;
        this.y = initLocation.field_72448_b;
        this.z = initLocation.field_72449_c;
        return this;
    }

    public TransformFunction setResultantSpeed(double resultantSpeed) {
        this.resultantSpeed = resultantSpeed;
        return this;
    }

    public TransformFunction setPlayer(PlayerEntity playerIn) {
        this.playerIn = playerIn;
        return this;
    }

    public TransformFunction setIncrement(double increment) {
        this.increment = increment;
        return this;
    }

    public TransformFunction addTransformUnit(TransformUnit transformUnit) {
        this.transformUnits.add(transformUnit);
        return this;
    }

    public PlayerEntity getPlayer() {
        return this.playerIn;
    }

    public World getWorld() {
        return this.worldIn;
    }

    public int getExecuteTimes() {
        return this.executeTimes;
    }

    public double getLifeSpan() {
        return this.lifeSpan;
    }

    public double getExecuteInterval() {
        return this.executeInterval;
    }

    public Vector3d getInitLocation() {
        return this.initLocation;
    }

    public Vector3d getShootVector() {
        return this.shootVector;
    }

    @Override
    public void rotate(Vector3d vecPrev, Vector3d incrementV3) {
        double incrementRoll = incrementV3.field_72450_a;
        double incrementYaw = incrementV3.field_72448_b;
        double incrementPitch = incrementV3.field_72449_c;
    }

    @Deprecated
    public Vector3d rotate(Vector3d prevPos, Vector3d pivotLocation, Vector3d rotationV3) {
        Vector3d rc;
        LineSegment3D hypotenuse;
        double radius = GSKOMathUtil.distanceOf3D(prevPos.field_72450_a, prevPos.field_72448_b, prevPos.field_72449_c, pivotLocation.field_72450_a, pivotLocation.field_72448_b, pivotLocation.field_72449_c);
        double incrementX = 0.0;
        double incrementY = 0.0;
        double incrementZ = 0.0;
        if (rotationV3.field_72450_a != 0.0) {
            hypotenuse = new LineSegment3D(pivotLocation.field_72450_a, pivotLocation.field_72448_b, 0.0, prevPos.field_72450_a, prevPos.field_72448_b, 0.0);
            rc = GSKOMathUtil.toRollCoordinate(hypotenuse.getLength(), rotationV3.field_72450_a);
            incrementX = rc.field_72450_a;
            incrementY = rc.field_72448_b;
        }
        if (rotationV3.field_72448_b != 0.0) {
            hypotenuse = new LineSegment3D(pivotLocation.field_72450_a, 0.0, pivotLocation.field_72449_c, prevPos.field_72450_a, 0.0, prevPos.field_72449_c);
            rc = GSKOMathUtil.toYawCoordinate(hypotenuse.getLength(), rotationV3.field_72448_b);
            incrementX = rc.field_72450_a;
            incrementZ = rc.field_72449_c;
        }
        if (rotationV3.field_72449_c != 0.0) {
            hypotenuse = new LineSegment3D(0.0, pivotLocation.field_72448_b, pivotLocation.field_72449_c, 0.0, prevPos.field_72448_b, prevPos.field_72449_c);
            rc = GSKOMathUtil.toPitchCoordinate(hypotenuse.getLength(), rotationV3.field_72449_c);
            incrementY = rc.field_72448_b;
            incrementZ = rc.field_72449_c;
        }
        this.x += incrementX;
        this.y += incrementY;
        this.z += incrementZ;
        return new Vector3d(prevPos.field_72450_a + incrementX, prevPos.field_72448_b + incrementY, prevPos.field_72449_c + incrementZ);
    }

    @Override
    public void transform(double x, double y, double z, double yaw, double pitch, double roll) {
    }

    @Override
    public Vector3d translate(double pivotX, double pivotY, double pivotZ) {
        this.pivotX = pivotX;
        this.pivotY = pivotY;
        this.pivotZ = pivotZ;
        return new Vector3d(pivotX, pivotY, pivotZ);
    }

    @Deprecated
    public Vector3d angleToVector(double incrementYawIn, double incrementPitchIn) {
        return new Vector3d(this.resultantSpeed * Math.sin(90.0 - incrementYawIn), this.resultantSpeed * Math.sin(incrementPitchIn) / Math.sin(90.0 - incrementPitchIn), this.resultantSpeed * Math.sin(incrementYawIn) / Math.sin(90.0));
    }

    @Deprecated
    public Vector3d angleToVector(double resultantSpeedIn, double incrementYawIn, double incrementPitchIn) {
        return new Vector3d(resultantSpeedIn * Math.sin(90.0 - incrementYawIn), resultantSpeedIn * Math.sin(incrementPitchIn) / Math.sin(90.0 - incrementPitchIn), resultantSpeedIn * Math.sin(incrementYawIn) / Math.sin(90.0));
    }

    @Override
    public Vector3d accelerate(Vector3d acceleration) {
        this.acceleration = acceleration;
        return this.acceleration;
    }

    public static class Builder
    extends TransformFunction {
        public static TransformFunction create() {
            return new TransformFunction();
        }
    }
}

