/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math;

import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.vector.Vector3d;

public class BezierUtil {
    public static Point2D getSmoothSegment2d(double time, ArrayList<Point2D> pointIn) {
        Point2D[] points = new Point2D[pointIn.size()];
        for (int k = 0; k < pointIn.size(); ++k) {
            points[k] = pointIn.get(k);
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4 - i - 1; ++j) {
                double x = (1.0 - time) * points[j].getX() + time * points[j + 1].getX();
                double y = (1.0 - time) * points[j].getY() + time * points[j + 1].getY();
                points[j] = new Point2D.Double(x, y);
            }
        }
        return points[0];
    }

    public static List<Vector3d> getBezierPos(Vector3d start, Vector3d end, Vector3d p, float time) {
        ArrayList<Vector3d> bezierPositions = new ArrayList<Vector3d>();
        int i = 0;
        while (i < 1) {
            bezierPositions.add(GSKOMathUtil.bezier2(start, end, p, time));
            i = (int)((float)i + time);
        }
        return bezierPositions;
    }
}

