/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math;

import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.common.util.math.function.CosineFunc;
import github.thelawf.gensokyoontology.common.util.math.function.SineFunc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class GSKOMathUtil {
    private GSKOMathUtil() {
    }

    public static double clampPeriod(double number, double min, double max) {
        return number % max - min == 0.0 && number / max <= 1.0 ? number : number - max * Math.floor(number / max);
    }

    public static float clampPeriod(float number, float min, float max) {
        return number % max - min == 0.0f && number / max <= 1.0f ? number : (float)((double)number - (double)max * Math.floor(number / max));
    }

    public static int clampPeriod(int number, int min, int max) {
        return number % max - min == 0 && number / max <= 1 ? number : (int)((double)number - (double)max * Math.floor((double)number / (double)max));
    }

    public static double distanceOf2D(double x1, double y1, double x2, double y2) {
        return Math.sqrt(GSKOMathUtil.square(x1 - x2) + GSKOMathUtil.square(y1 - y2));
    }

    public static double distanceOf3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 + z2, 2.0), 0.5);
    }

    public static ArrayList<Vector3d> getCirclePoints2D(Vector3d center, double radius, int count) {
        ArrayList<Vector3d> coordinates = new ArrayList<Vector3d>();
        double radians = Math.PI / 180 * (double)Math.round(360.0 / (double)count);
        for (int i = 0; i < count; ++i) {
            double x = center.func_82615_a() + radius * Math.sin(radians * (double)i);
            double y = center.func_82617_b() + radius * Math.cos(radians * (double)i);
            Vector3d coordinate = new Vector3d(x, y, 0.0);
            coordinates.add(coordinate);
        }
        return coordinates;
    }

    public static Vector3d getPointOnCircle(Vector3d center, double radius, double angle) {
        return new Vector3d(center.func_82615_a() + radius * Math.cos(Math.toDegrees(angle)), 0.0, center.func_82616_c() + radius * Math.sin(Math.toDegrees(angle)));
    }

    public static Vector3d bezier2(Vector3d start, Vector3d end, Vector3d p, float time) {
        return GSKOMathUtil.lerp(time, GSKOMathUtil.lerp(time, start, p), GSKOMathUtil.lerp(time, p, end));
    }

    public static Vector3d bezier2(Vector3d start, Vector3d end, Vector3d p, double time) {
        if (time > 1.0 || time < 0.0) {
            return null;
        }
        Vector3d v1 = start.func_186678_a(GSKOMathUtil.pow2(1.0 - time));
        Vector3d v2 = p.func_186678_a(2.0 * time * (1.0 - time));
        Vector3d v3 = end.func_186678_a(GSKOMathUtil.pow2(time));
        return v1.func_178787_e(v2.func_178787_e(v3));
    }

    public static Vector3d bezier3(Vector3d p1, Vector3d p2, Vector3d q1, Vector3d q2, float time) {
        if (time > 1.0f || time < 0.0f) {
            return null;
        }
        Vector3d v1 = GSKOMathUtil.lerp(time, p1, q1);
        Vector3d v2 = GSKOMathUtil.lerp(time, q1, q2);
        Vector3d v3 = GSKOMathUtil.lerp(time, q2, p2);
        Vector3d inner1 = GSKOMathUtil.lerp(time, v1, v2);
        Vector3d inner2 = GSKOMathUtil.lerp(time, v2, v3);
        return GSKOMathUtil.lerp(time, inner1, inner2);
    }

    public static Vector3d bezierDerivative(Vector3d p1, Vector3d p2, Vector3d q1, Vector3d q2, float t) {
        return p1.func_186678_a((double)(-3.0f * t * t + 6.0f * t - 3.0f)).func_178787_e(q1.func_186678_a((double)(9.0f * t * t - 12.0f * t + 3.0f))).func_178787_e(q2.func_186678_a((double)(-9.0f * t * t + 6.0f * t))).func_178787_e(p2.func_186678_a((double)(3.0f * t * t)));
    }

    public static Vector3d lerp(float progress, Vector3d start, Vector3d end) {
        return start.func_178787_e(end.func_178788_d(start).func_186678_a((double)progress));
    }

    public static BlockPos lerp(float progress, BlockPos start, BlockPos end) {
        int x = MathHelper.func_76141_d((float)MathHelper.func_219799_g((float)progress, (float)start.func_177958_n(), (float)end.func_177958_n()));
        int y = MathHelper.func_76141_d((float)MathHelper.func_219799_g((float)progress, (float)start.func_177956_o(), (float)end.func_177956_o()));
        int z = MathHelper.func_76141_d((float)MathHelper.func_219799_g((float)progress, (float)start.func_177952_p(), (float)end.func_177952_p()));
        return new BlockPos(x, y, z);
    }

    public static float lerpTicks(float partial, int maxTick, int presentTick, float minValue, float maxValue) {
        return MathHelper.func_219799_g((float)(((float)presentTick + partial) / (float)maxTick), (float)minValue, (float)maxValue);
    }

    public static double toModulus3D(double x, double y, double z) {
        return Math.pow(x * x + y * y + z * z, 0.5);
    }

    public static double toModulus2D(double x, double y) {
        return Math.pow(x * x + y * y, 0.5);
    }

    public static Vector3d toRectVec(Vector3d sc) {
        return new Vector3d(sc.field_72450_a * Math.sin(sc.field_72448_b) * Math.cos(sc.field_72449_c), sc.field_72450_a * Math.sin(sc.field_72448_b) * Math.sin(sc.field_72449_c), sc.field_72450_a * Math.cos(sc.field_72448_b));
    }

    public static Vector3d toSphereVec(Vector3d rc) {
        double r = GSKOMathUtil.toModulus3D(rc.field_72450_a, rc.field_72448_b, rc.field_72449_c);
        return new Vector3d(r, Math.acos(rc.field_72449_c / r), Math.atan(rc.field_72448_b / rc.field_72450_a));
    }

    public static Vector3d toSphereVec(double x, double y, double z) {
        return GSKOMathUtil.toSphereVec(new Vector3d(x, y, z));
    }

    public static List<Vector3d> rotateCircle(List<Vector3d> circleDots, double thetaRotation, double phiRotation) {
        ArrayList<Vector3d> nextCircleDots = new ArrayList<Vector3d>();
        for (Vector3d dotOnCircle : circleDots) {
            Vector3d prevSphereVec = GSKOMathUtil.toSphereVec(dotOnCircle);
            Vector3d nextSphereVec = new Vector3d(prevSphereVec.field_72450_a, prevSphereVec.field_72448_b + thetaRotation, prevSphereVec.field_72449_c + phiRotation);
            nextCircleDots.add(GSKOMathUtil.toRectVec(nextSphereVec));
        }
        return nextCircleDots;
    }

    public static Vector3d rotateCircleDot(Vector3d rectVec, double thetaRotation, double phiRotation) {
        Vector3d sphereVec = GSKOMathUtil.toSphereVec(rectVec);
        return new Vector3d(sphereVec.field_72450_a, sphereVec.field_72448_b + thetaRotation, sphereVec.field_72449_c + phiRotation);
    }

    public static Vector3d toLocalCoordinate(Vector3d newOriginIn, Vector3d globalIn) {
        return new Vector3d(globalIn.func_82615_a() - newOriginIn.func_82615_a(), globalIn.func_82617_b() - newOriginIn.func_82617_b(), globalIn.func_82616_c() - newOriginIn.func_82616_c());
    }

    public static Vector3d toRollCoordinate(double hypotenuse, double roll) {
        double x = Math.sqrt(Math.pow(hypotenuse, 2.0) / Math.pow(Math.tan(roll), 2.0) + 1.0);
        return new Vector3d(x, Math.tan(roll) * x, 0.0);
    }

    public static Vector3d toYawCoordinate(double hypotenuse, double yaw) {
        double z = Math.sqrt(Math.pow(hypotenuse, 2.0) / Math.pow(Math.tan(yaw), 2.0) + 1.0);
        return new Vector3d(Math.tan(yaw) * z, 0.0, z);
    }

    public static Vector3d toPitchCoordinate(double hypotenuse, double pitch) {
        double y = Math.sqrt(Math.pow(hypotenuse, 2.0) / Math.pow(Math.tan(pitch), 2.0) + 1.0);
        return new Vector3d(0.0, y, Math.tan(pitch) * y);
    }

    public static Vector3d vecCeil(Vector3d vec) {
        return new Vector3d(Math.ceil(vec.func_82615_a()), Math.ceil(vec.func_82617_b()), Math.ceil(vec.func_82616_c()));
    }

    public static Vector3d vecFloor(Vector3d vec) {
        return new Vector3d(Math.floor(vec.func_82615_a()), Math.floor(vec.func_82617_b()), Math.floor(vec.func_82616_c()));
    }

    public static Vector2f getEulerAngle(Vector3d vectorA, Vector3d vectorB) {
        double m11 = vectorA.field_72450_a * vectorB.field_72450_a + vectorA.field_72448_b * vectorB.field_72448_b;
        double m12 = vectorA.field_72450_a * vectorB.field_72448_b - vectorA.field_72448_b * vectorB.field_72450_a;
        double m13 = vectorA.field_72449_c * vectorB.field_72450_a;
        double m31 = -vectorA.field_72448_b;
        double m32 = vectorA.field_72450_a;
        double m33 = 0.0;
        double yaw = Math.atan2(m12, m11);
        double pitch = Math.asin(m31);
        return new Vector2f((float)yaw, (float)pitch);
    }

    public static int randomRange(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    public static float randomRange(float min, float max) {
        Random random = new Random();
        float randomValue = random.nextFloat();
        return min + randomValue * (max - min);
    }

    public static double randomRange(double min, double max) {
        Random random = new Random();
        double randomValue = random.nextDouble();
        return min + randomValue * (max - min);
    }

    public static Vector3d randomVec(double min, double max) {
        return new Vector3d(GSKOMathUtil.randomRange(min, max), GSKOMathUtil.randomRange(min, max), GSKOMathUtil.randomRange(min, max));
    }

    public static Pair<Vector3d, Vector3d> rsr(Vector3d orientation, float yawRange, float pitchRange) {
        double yaw = GSKOMathUtil.toYawPitch((Vector3d)orientation).field_189982_i;
        double pitch = GSKOMathUtil.toYawPitch((Vector3d)orientation).field_189983_j;
        if (yaw < (double)yawRange || yaw >= (double)yawRange) {
            if (pitch > (double)pitchRange) {
                return Pair.of((Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange), (Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange).func_216371_e());
            }
            if (pitch < (double)pitchRange) {
                return Pair.of((Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange), (Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange).func_216371_e());
            }
            return Pair.of((Object)GSKOMathUtil.fromYawPitch(yawRange, (float)pitch), (Object)GSKOMathUtil.fromYawPitch(yawRange, (float)pitch).func_216371_e());
        }
        if (pitch > (double)pitchRange) {
            return Pair.of((Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange), (Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange).func_216371_e());
        }
        if (pitch < (double)pitchRange) {
            return Pair.of((Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange), (Object)GSKOMathUtil.fromYawPitch(yawRange, pitchRange).func_216371_e());
        }
        return Pair.of((Object)orientation, (Object)orientation.func_216371_e());
    }

    public static <V> V rollByWeight(int total, int weight, V value) {
        return new Random().nextInt(total) < weight ? null : (V)value;
    }

    public static Vector2f toYawPitch(Vector3d vector3d) {
        double yaw = Math.atan2(-vector3d.field_72450_a, vector3d.field_72449_c);
        double pitch = Math.atan2(vector3d.field_72448_b, Math.sqrt(vector3d.field_72450_a * vector3d.field_72450_a + vector3d.field_72449_c * vector3d.field_72449_c));
        return new Vector2f((float)GSKOMathUtil.toDegree(yaw), (float)GSKOMathUtil.toDegree(pitch));
    }

    public static Vector3d fromYawPitch(float yaw, float pitch) {
        return new Vector3d(Math.cos(yaw) * Math.cos(pitch), Math.sin(yaw) * Math.sin(pitch), Math.sin(pitch));
    }

    public static double toDegree(double radIn) {
        return radIn / Math.PI * 180.0;
    }

    public static double toRadian(double degIn) {
        return degIn * Math.PI / 180.0;
    }

    public static double pow2(double base) {
        return GSKOMathUtil.square(base);
    }

    public static double pow3(double base) {
        return GSKOMathUtil.cube(base);
    }

    public static double square(double base) {
        return base * base;
    }

    public static double cube(double base) {
        return base * base * base;
    }

    public static Vector3d rotatePitchYaw(Vector3d prev, float pitch, float yaw) {
        CosineFunc cf = new CosineFunc(prev.field_72450_a, 1.0, 0.0);
        SineFunc sf = new SineFunc(1.0, 1.0, 0.0);
        double x = 0.0;
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public static void generateBlockOnBezierCurve(World world, Block block, BlockPos start, BlockPos end) {
        double dist = start.func_177951_i((Vector3i)end);
        double mx = (double)(start.func_177958_n() + end.func_177958_n()) / 2.0;
        double my = (double)(start.func_177956_o() + end.func_177956_o()) / 2.0 + dist / 16.0;
        double mz = (double)(start.func_177952_p() + end.func_177952_p()) / 2.0;
        double cx = ((double)(start.func_177958_n() + end.func_177958_n()) + my - (double)start.func_177956_o()) / 2.0;
        double cz = ((double)(start.func_177952_p() + end.func_177952_p()) + my - (double)start.func_177956_o()) / 2.0;
        int numPoints = (int)Math.sqrt(dist) * 2;
        for (int i = 0; i <= numPoints; ++i) {
            double z;
            double y;
            double t = (double)i / (double)numPoints;
            double x = Math.pow(1.0 - t, 2.0) * (double)start.func_177958_n() + 2.0 * (1.0 - t) * t * cx + Math.pow(t, 2.0) * (double)end.func_177958_n();
            BlockPos pos = new BlockPos(x, y = Math.pow(1.0 - t, 2.0) * (double)start.func_177956_o() + 2.0 * (1.0 - t) * t * my + Math.pow(t, 2.0) * (double)end.func_177956_o(), z = Math.pow(1.0 - t, 2.0) * (double)start.func_177952_p() + 2.0 * (1.0 - t) * t * cz + Math.pow(t, 2.0) * (double)end.func_177952_p());
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) continue;
            world.func_175656_a(pos, block.func_176223_P());
        }
    }

    public static ArrayList<Vector3d> getBlocksOnBezierCurve(BlockPos start, BlockPos end) {
        double dist = start.func_177951_i((Vector3i)end);
        ArrayList<Vector3d> vecList = new ArrayList<Vector3d>();
        double mx = (double)(start.func_177958_n() + end.func_177958_n()) / 2.0;
        double my = (double)(start.func_177956_o() + end.func_177956_o()) / 2.0 + dist / 16.0;
        double mz = (double)(start.func_177952_p() + end.func_177952_p()) / 2.0;
        double cx = ((double)(start.func_177958_n() + end.func_177958_n()) + my - (double)start.func_177956_o()) / 2.0;
        double cz = ((double)(start.func_177952_p() + end.func_177952_p()) + my - (double)start.func_177956_o()) / 2.0;
        int numPoints = (int)Math.sqrt(dist) * 2;
        for (int i = 0; i <= numPoints; ++i) {
            double t = (double)i / (double)numPoints;
            double x = Math.pow(1.0 - t, 2.0) * (double)start.func_177958_n() + 2.0 * (1.0 - t) * t * cx + Math.pow(t, 2.0) * (double)end.func_177958_n();
            double y = Math.pow(1.0 - t, 2.0) * (double)start.func_177956_o() + 2.0 * (1.0 - t) * t * my + Math.pow(t, 2.0) * (double)end.func_177956_o();
            double z = Math.pow(1.0 - t, 2.0) * (double)start.func_177952_p() + 2.0 * (1.0 - t) * t * cz + Math.pow(t, 2.0) * (double)end.func_177952_p();
            vecList.add(new Vector3d(x, y, z));
        }
        return vecList;
    }

    public static Quaternion conjugate(Quaternion quaternionIn) {
        return new Quaternion(-quaternionIn.func_195889_a(), -quaternionIn.func_195891_b(), -quaternionIn.func_195893_c(), quaternionIn.func_195894_d());
    }

    public static Quaternion vecToQuaternion(Vector3d vector3d) {
        double yaw = Math.atan2(vector3d.field_72449_c, vector3d.field_72450_a);
        double pitch = Math.asin(vector3d.field_72448_b);
        Quaternion quaternion = new Quaternion(Vector3f.field_229181_d_, (float)Math.toDegrees(-yaw), true);
        quaternion.func_195890_a(new Quaternion(Vector3f.field_229179_b_, (float)Math.toDegrees(pitch), true));
        return quaternion;
    }

    public static Quaternion vecToQuaternion(Vector3f vector3f) {
        double yaw = Math.atan2(vector3f.func_195902_c(), vector3f.func_195899_a());
        double pitch = Math.asin(vector3f.func_195900_b());
        Quaternion quaternion = new Quaternion(Vector3f.field_229181_d_, (float)Math.toDegrees(-yaw), true);
        quaternion.func_195890_a(new Quaternion(Vector3f.field_229179_b_, (float)Math.toDegrees(pitch), true));
        return quaternion;
    }

    public static boolean isBetween(int num, int min, int max) {
        return num >= min && num < max;
    }

    public static boolean isBetween(float num, float min, float max) {
        return num >= min && num < max;
    }

    public static boolean isBetween(double num, double min, double max) {
        return num >= min && num < max;
    }
}

