/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class GeometryUtil {
    public static final double PHI = (1.0 + Math.sqrt(5.0)) / 2.0;
    public static final double PHI_RECIPROCAL = 1.0 / PHI;

    private static void regularIcosahedron(IVertexBuilder builder, Matrix4f matrix4f, float a, float red, float green, float blue, float alpha) {
        double scale = 1.0;
        double phiS = 1.0 * PHI;
        double phiSR = 1.0 * PHI_RECIPROCAL;
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, 1.0), GeometryUtil.of(1.0, 1.0, -1.0), GeometryUtil.of(0.0, phiS, phiSR));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, 1.0), GeometryUtil.of(0.0, phiS, phiSR), GeometryUtil.of(-1.0, 1.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, 1.0), GeometryUtil.of(-1.0, 1.0, 1.0), GeometryUtil.of(phiS, phiSR, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, 1.0), GeometryUtil.of(phiS, phiSR, 0.0), GeometryUtil.of(phiSR, 0.0, phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, 1.0), GeometryUtil.of(phiSR, 0.0, phiS), GeometryUtil.of(1.0, 1.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, -1.0), GeometryUtil.of(phiSR, 0.0, -phiS), GeometryUtil.of(0.0, phiS, -phiSR));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, 1.0, -1.0), GeometryUtil.of(0.0, phiS, -phiSR), GeometryUtil.of(0.0, phiS, phiSR));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, 1.0), GeometryUtil.of(0.0, -phiS, phiSR), GeometryUtil.of(-1.0, -1.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, 1.0), GeometryUtil.of(-1.0, -1.0, 1.0), GeometryUtil.of(-phiSR, 0.0, phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, 1.0), GeometryUtil.of(-phiSR, 0.0, phiS), GeometryUtil.of(phiS, -phiSR, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, 1.0), GeometryUtil.of(phiS, -phiSR, 0.0), GeometryUtil.of(phiSR, 0.0, phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, 1.0), GeometryUtil.of(phiSR, 0.0, phiS), GeometryUtil.of(0.0, -phiS, phiSR));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, -1.0), GeometryUtil.of(-1.0, 1.0, -1.0), GeometryUtil.of(0.0, -phiS, -phiSR));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, -1.0), GeometryUtil.of(0.0, -phiS, -phiSR), GeometryUtil.of(-phiSR, 0.0, -phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, -1.0), GeometryUtil.of(-phiSR, 0.0, -phiS), GeometryUtil.of(-1.0, -1.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, -1.0), GeometryUtil.of(-1.0, -1.0, -1.0), GeometryUtil.of(phiSR, 0.0, -phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, -1.0, -1.0), GeometryUtil.of(phiSR, 0.0, -phiS), GeometryUtil.of(-1.0, 1.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-1.0, 1.0, 1.0), GeometryUtil.of(-phiS, phiSR, 0.0), GeometryUtil.of(-phiSR, 0.0, phiS));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-1.0, 1.0, 1.0), GeometryUtil.of(-phiSR, 0.0, phiS), GeometryUtil.of(-1.0, -1.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-1.0, 1.0, -1.0), GeometryUtil.of(0.0, -phiS, -phiSR), GeometryUtil.of(-phiSR, 0.0, -phiS));
    }

    public static void regularIcosahedron(IVertexBuilder builder, Matrix4f matrix4f, float red, float green, float blue, float alpha) {
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, PHI), GeometryUtil.of(0.0, 1.0, -PHI), GeometryUtil.of(1.0, PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, PHI), GeometryUtil.of(0.0, 1.0, -PHI), GeometryUtil.of(-1.0, PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, PHI), GeometryUtil.of(1.0, PHI, 0.0), GeometryUtil.of(PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, PHI), GeometryUtil.of(-1.0, PHI, 0.0), GeometryUtil.of(-PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, -PHI), GeometryUtil.of(PHI, 0.0, -1.0), GeometryUtil.of(1.0, PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, 1.0, -PHI), GeometryUtil.of(-1.0, PHI, 0.0), GeometryUtil.of(-PHI, 0.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, PHI), GeometryUtil.of(0.0, -1.0, -PHI), GeometryUtil.of(1.0, -PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, PHI), GeometryUtil.of(0.0, -1.0, -PHI), GeometryUtil.of(-1.0, -PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, PHI), GeometryUtil.of(1.0, -PHI, 0.0), GeometryUtil.of(PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, PHI), GeometryUtil.of(-1.0, -PHI, 0.0), GeometryUtil.of(-PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, -PHI), GeometryUtil.of(PHI, 0.0, -1.0), GeometryUtil.of(1.0, -PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(0.0, -1.0, -PHI), GeometryUtil.of(-1.0, -PHI, 0.0), GeometryUtil.of(-PHI, 0.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, PHI, 0.0), GeometryUtil.of(1.0, -PHI, 0.0), GeometryUtil.of(PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(1.0, PHI, 0.0), GeometryUtil.of(PHI, 0.0, -1.0), GeometryUtil.of(1.0, -PHI, 0.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-1.0, PHI, 0.0), GeometryUtil.of(-1.0, -PHI, 0.0), GeometryUtil.of(-PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-1.0, PHI, 0.0), GeometryUtil.of(-1.0, -PHI, 0.0), GeometryUtil.of(-PHI, 0.0, -1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(PHI, 0.0, 1.0), GeometryUtil.of(PHI, 0.0, -1.0), GeometryUtil.of(-PHI, 0.0, 1.0));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(PHI, 0.0, 1.0), GeometryUtil.of(-PHI, 0.0, 1.0), GeometryUtil.of(0.0, 1.0, PHI));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(PHI, 0.0, -1.0), GeometryUtil.of(-PHI, 0.0, -1.0), GeometryUtil.of(0.0, 1.0, -PHI));
        GeometryUtil.triangularFace(builder, matrix4f, red, green, blue, alpha, GeometryUtil.of(-PHI, 0.0, 1.0), GeometryUtil.of(-PHI, 0.0, -1.0), GeometryUtil.of(0.0, -1.0, PHI));
    }

    public static void renderIcosahedron(IVertexBuilder builder, Matrix4f matrix4f, float size, int subdivisionLevel, float red, float green, float blue, float alpha) {
        int[][] faces;
        float X = 0.5257311f * size;
        float Z = 0.8506508f * size;
        float[][] vertices = new float[][]{{-X, 0.0f, Z}, {X, 0.0f, Z}, {-X, 0.0f, -Z}, {X, 0.0f, -Z}, {0.0f, Z, X}, {0.0f, Z, -X}, {0.0f, -Z, X}, {0.0f, -Z, -X}, {Z, X, 0.0f}, {-Z, X, 0.0f}, {Z, -X, 0.0f}, {-Z, -X, 0.0f}};
        for (int[] face : faces = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}}) {
            GeometryUtil.renderTriangle(matrix4f, builder, vertices[face[0]], vertices[face[1]], vertices[face[2]], red, green, blue, alpha);
        }
    }

    public static void renderSphere(IVertexBuilder builder, Matrix4f matrix4f, int latitudeBands, int longitudeBands, float radius, float r, float g, float b, float a) {
        int[][] faces;
        float[][] vertices = GeometryUtil.longitudeSphereVertices(latitudeBands, longitudeBands, radius);
        for (int[] face : faces = GeometryUtil.longitudeSphereFaces(latitudeBands, longitudeBands)) {
            GeometryUtil.renderTriangle(matrix4f, builder, vertices[face[0]], vertices[face[1]], vertices[face[2]], r, g, b, a);
        }
    }

    public static void renderCylinder(IVertexBuilder builder, Matrix4f matrix4f, float radius, float height, int segment, float r, float g, float b, float a) {
        for (float[] vertex : GeometryUtil.cylinderMeshes(builder, matrix4f, radius, height, segment)) {
            builder.func_227888_a_(matrix4f, vertex[0], vertex[1], vertex[2]).func_227885_a_(r, g, b, a).func_181675_d();
        }
    }

    public static List<float[]> cylinderMeshes(IVertexBuilder builder, Matrix4f matrix4f, float radius, float height, int segments) {
        int i;
        ArrayList<float[]> vertices = new ArrayList<float[]>();
        for (i = 0; i < segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)((double)radius * Math.cos(angle));
            float z = (float)((double)radius * Math.sin(angle));
            vertices.add(new float[]{x, height / 2.0f, z});
            vertices.add(new float[]{x, -height / 2.0f, z});
        }
        for (i = 0; i < segments; ++i) {
            int next = (i + 1) % segments;
            float[] topCurrent = (float[])vertices.get(i * 2);
            float[] bottomCurrent = (float[])vertices.get(i * 2 + 1);
            float[] topNext = (float[])vertices.get(next * 2);
            float[] bottomNext = (float[])vertices.get(next * 2 + 1);
            vertices.add(topCurrent);
            vertices.add(bottomCurrent);
            vertices.add(topNext);
            vertices.add(bottomCurrent);
            vertices.add(bottomNext);
            vertices.add(topNext);
        }
        return vertices;
    }

    private static float[][] longitudeSphereVertices(int latitudeBands, int longitudeBands, float radius) {
        int vertexCount = (latitudeBands + 1) * (longitudeBands + 1);
        float[][] vertices = new float[vertexCount][3];
        int index = 0;
        for (int latNumber = 0; latNumber <= latitudeBands; ++latNumber) {
            float theta = (float)((double)latNumber * Math.PI / (double)latitudeBands);
            float sinTheta = (float)Math.sin(theta);
            float cosTheta = (float)Math.cos(theta);
            for (int longNumber = 0; longNumber <= longitudeBands; ++longNumber) {
                float phi = (float)((double)(longNumber * 2) * Math.PI / (double)longitudeBands);
                float sinPhi = (float)Math.sin(phi);
                float cosPhi = (float)Math.cos(phi);
                float x = cosPhi * sinTheta;
                float y = cosTheta;
                float z = sinPhi * sinTheta;
                vertices[index][0] = radius * x;
                vertices[index][1] = radius * y;
                vertices[index][2] = radius * z;
                ++index;
            }
        }
        return vertices;
    }

    private static int[][] longitudeSphereFaces(int latitudeBands, int longitudeBands) {
        int indexCount = latitudeBands * longitudeBands * 6;
        int[][] indices = new int[indexCount / 3][3];
        int index = 0;
        for (int latNumber = 0; latNumber < latitudeBands; ++latNumber) {
            for (int longNumber = 0; longNumber < longitudeBands; ++longNumber) {
                int first = latNumber * (longitudeBands + 1) + longNumber;
                int second = first + longitudeBands + 1;
                indices[index][0] = first;
                indices[index][1] = second;
                indices[index][2] = first + 1;
                indices[++index][0] = second;
                indices[index][1] = second + 1;
                indices[index][2] = first + 1;
                ++index;
            }
        }
        return indices;
    }

    private static void renderTriangle(Matrix4f matrix, IVertexBuilder vertexBuilder, float[] v1, float[] v2, float[] v3, float red, float green, float blue, float alpha) {
        GeometryUtil.addVertex(matrix, vertexBuilder, v1, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v2, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v3, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v1, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v3, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v2, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v3, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v2, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v1, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v2, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v1, red, green, blue, alpha);
        GeometryUtil.addVertex(matrix, vertexBuilder, v3, red, green, blue, alpha);
    }

    private static void addVertex(Matrix4f matrix, IVertexBuilder vertexBuilder, float[] pos, float red, float green, float blue, float alpha) {
        vertexBuilder.func_227888_a_(matrix, pos[0], pos[1], pos[2]).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void triangularFace(IVertexBuilder builder, Matrix4f matrix4f, Vector3f a, Vector3f b, Vector3f c) {
        builder.func_227888_a_(matrix4f, a.func_195899_a(), a.func_195900_b(), a.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, b.func_195899_a(), b.func_195900_b(), b.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, c.func_195899_a(), c.func_195900_b(), c.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, c.func_195899_a(), c.func_195900_b(), c.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, b.func_195899_a(), b.func_195900_b(), b.func_195902_c()).func_181675_d();
        builder.func_227888_a_(matrix4f, a.func_195899_a(), a.func_195900_b(), a.func_195902_c()).func_181675_d();
    }

    public static Vector3f of(double x, double y, double z) {
        return new Vector3f((float)x, (float)y, (float)z);
    }

    public static void triangularFace(IVertexBuilder builder, Matrix4f matrix4f, float red, float green, float blue, float alpha, Vector3f a, Vector3f b, Vector3f c) {
        builder.func_227888_a_(matrix4f, a.func_195899_a(), a.func_195900_b(), a.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, b.func_195899_a(), b.func_195900_b(), b.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, c.func_195899_a(), c.func_195900_b(), c.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, c.func_195899_a(), c.func_195900_b(), c.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, b.func_195899_a(), b.func_195900_b(), b.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, a.func_195899_a(), a.func_195900_b(), a.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }
}

