/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math.function;

import github.thelawf.gensokyoontology.common.util.math.function.MathFunc;
import java.util.Objects;

@FunctionalInterface
public interface MathExpression<F extends MathFunc> {
    public double compute(F var1, double var2);

    default public MathExpression<F> add(MathExpression<F> other) {
        Objects.requireNonNull(other);
        return (t, x) -> other.compute(t, x) + this.compute(t, x);
    }

    default public MathExpression<F> mul(MathExpression<F> other) {
        Objects.requireNonNull(other);
        return (t, x) -> other.compute(t, x) * this.compute(t, x);
    }

    default public MathExpression<F> subtract(MathExpression<F> other) {
        Objects.requireNonNull(other);
        return (t, x) -> this.compute(t, x) - other.compute(t, x);
    }

    default public MathExpression<F> divide(MathExpression<F> other) {
        Objects.requireNonNull(other);
        return (t, x) -> this.compute(t, x) / other.compute(t, x);
    }

    default public MathExpression<F> pow(MathExpression<F> other) {
        Objects.requireNonNull(other);
        return (t, x) -> Math.pow(this.compute(t, x), other.compute(t, x));
    }

    default public double getResult(F t, double x) {
        Objects.requireNonNull(t);
        return this.compute(t, x);
    }

    default public MathExpression<F> map(F t, double x) {
        Objects.requireNonNull(t);
        return (func, x1) -> this.compute(t, x);
    }
}

