/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math.function;

import github.thelawf.gensokyoontology.common.util.math.function.MathFunc;

public class Monomial
implements MathFunc {
    public float coefficient;
    public float time;
    public float constance = 0.0f;

    public Monomial(float coefficient, float time) {
        this.coefficient = coefficient;
        this.time = time;
    }

    @Override
    public double computeResult(double x) {
        return (double)Math.round(Math.pow(x, this.time) * (double)this.coefficient * 100.0) * 0.01 + (double)this.constance;
    }

    public static Monomial of(float coefficient, float time) {
        return new Monomial(coefficient, time);
    }

    public static Monomial of(float coefficient, float time, float constance) {
        Monomial monomial = new Monomial(coefficient, time);
        monomial.constance = constance;
        return monomial;
    }

    public void withConst(float constance) {
        this.constance = constance;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.coefficient > 0.0f) {
            builder.append("+");
        }
        if (this.coefficient != 0.0f) {
            if (this.coefficient != 1.0f) {
                builder.append(this.coefficient);
            }
            builder.append("x");
        }
        if (this.time != 1.0f && this.time != 0.0f) {
            builder.append("^");
            builder.append(this.time);
        }
        if (this.constance != 0.0f) {
            builder.append(this.constance);
        }
        return builder.toString();
    }
}

