/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math.function;

import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.common.util.math.function.Monomial;
import github.thelawf.gensokyoontology.common.util.math.function.RationalFunc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class PolynomialFunc
extends RationalFunc {
    public List<Pair<Float, Float>> values = new ArrayList<Pair<Float, Float>>();
    public List<Monomial> monomials = new ArrayList<Monomial>();

    public PolynomialFunc(List<Monomial> monomials) {
        this.monomials = monomials;
        for (Monomial monomial : this.monomials) {
            this.values.add((Pair<Float, Float>)Pair.of((Object)Float.valueOf(monomial.coefficient), (Object)Float.valueOf(monomial.time)));
        }
    }

    public PolynomialFunc(List<Float> coefficients, List<Float> times) {
        if (coefficients.size() == 0 || times.size() == 0) {
            throw new IllegalStateException("List is empty!");
        }
        if (coefficients.size() != times.size()) {
            throw new IllegalStateException("The size of the two list is not the same!");
        }
        for (int i = 0; i < coefficients.size(); ++i) {
            Pair pair = Pair.of((Object)coefficients.get(i), (Object)times.get(i));
            this.monomials.add(Monomial.of(coefficients.get(i).floatValue(), times.get(i).floatValue()));
            this.values.add((Pair<Float, Float>)pair);
        }
    }

    public static PolynomialFunc of(Monomial ... monomials) {
        return new PolynomialFunc(new ArrayList<Monomial>(Arrays.asList(monomials)));
    }

    @Override
    public double computeResult(double x) {
        AtomicReference<Double> res = new AtomicReference<Double>(0.0);
        this.monomials.forEach(monomial -> {
            Double cfr_ignored_0 = (Double)res.updateAndGet(v -> v + monomial.computeResult(x));
        });
        return (double)Math.round(res.get() * 100.0) * 0.01;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("f(x)=");
        for (Monomial m : this.monomials) {
            char[] chars;
            builder.append(m.toString());
            if (this.monomials.indexOf(m) != 0 || (chars = builder.toString().toCharArray())[5] != '+') continue;
            builder.delete(5, 6);
        }
        return builder.toString();
    }
}

