/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math.function;

import github.thelawf.gensokyoontology.common.util.math.function.Monomial;
import github.thelawf.gensokyoontology.common.util.math.function.PolynomialFunc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class PolynomialParser {
    public static PolynomialFunc parsePolynomial(String polynomialPattern) {
        String[] strings;
        ArrayList<Monomial> monomials = new ArrayList<Monomial>();
        String s1 = polynomialPattern.replace(" ", "");
        for (String str : strings = s1.split("\\+")) {
            if (str.contains("-")) {
                char[] chars = str.toCharArray();
                ArrayList<Character> characters = PolynomialParser.toListChar(chars);
                monomials.addAll(PolynomialParser.tryParseMinus(characters));
                continue;
            }
            monomials.add(PolynomialParser.parseMonomial(str));
        }
        return new PolynomialFunc(monomials);
    }

    public static Monomial parseMonomial(String pattern, boolean isNegative) {
        if (!isNegative) {
            return PolynomialParser.parseMonomial(pattern);
        }
        if (pattern.contains("^")) {
            String[] s2 = pattern.split("\\^");
            return Monomial.of(Float.parseFloat(s2[0].replaceAll("[^\\-0-9.]", "").trim()), Float.parseFloat(s2[1].replaceAll("[^\\-0-9.]", "").trim()));
        }
        if (Pattern.compile("[\\^+-.0-9]").matcher(pattern).find() && Pattern.compile("[^\\-+.0-9]").matcher(pattern).find()) {
            return Monomial.of(Float.parseFloat(pattern.replaceAll("[^\\-0-9.]", "").trim()), 0.0f);
        }
        if (Pattern.compile("[+\\-.0-9]").matcher(pattern).find()) {
            Monomial monomial = Monomial.of(0.0f, 0.0f);
            monomial.withConst(Float.parseFloat(pattern));
            return monomial;
        }
        return new Monomial(0.0f, 0.0f);
    }

    public static Monomial parseMonomial(String pattern) {
        String[] s2 = pattern.split("\\^");
        if (s2.length == 2) {
            return Monomial.of(Float.parseFloat(s2[0].replaceAll("[^\\-0-9.]", "").trim().equals("") ? "1.0" : s2[0].replaceAll("[^\\-0-9.]", "").trim()), Float.parseFloat(s2[1].replaceAll("[^\\-0-9.]", "").trim()));
        }
        return Monomial.of(Float.parseFloat(s2[0].replaceAll("[^\\-0-9.]", "").trim().equals("") ? "1.0" : s2[0].replaceAll("[^\\-0-9.]", "").trim()), 0.0f);
    }

    private static ArrayList<Character> toListChar(char[] chars) {
        Character[] result = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Character.valueOf(chars[i]);
        }
        return new ArrayList<Character>(Arrays.asList(result));
    }

    private static List<Monomial> tryParseMinus(ArrayList<Character> characters) {
        ArrayList<Monomial> ms = new ArrayList<Monomial>();
        StringBuilder builder = new StringBuilder();
        characters.forEach(builder::append);
        String[] strings = builder.toString().split("-");
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                ms.add(PolynomialParser.parseMonomial(strings[i]));
                continue;
            }
            String s = "-" + strings[i];
            ms.add(PolynomialParser.parseMonomial(s, true));
        }
        return ms;
    }
}

