/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.math.function;

import github.thelawf.gensokyoontology.common.util.math.function.TrigonometricFunc;
import java.util.Objects;

@FunctionalInterface
public interface Trigonometric<T extends TrigonometricFunc> {
    public double compute(T var1, double var2);

    default public Trigonometric<T> add(Trigonometric<T> other) {
        Objects.requireNonNull(other);
        return (t, x) -> other.compute(t, x) + this.compute(t, x);
    }

    default public Trigonometric<T> mul(Trigonometric<T> other) {
        Objects.requireNonNull(other);
        return (t, x) -> other.compute(t, x) * this.compute(t, x);
    }

    default public Trigonometric<T> pow(Trigonometric<T> other) {
        Objects.requireNonNull(other);
        return (t, x) -> other.compute(t, x) * this.compute(t, x);
    }

    default public double getResult(T t, double x) {
        Objects.requireNonNull(t);
        return this.compute(t, x);
    }

    default public Trigonometric<T> map(T t, double x) {
        Objects.requireNonNull(t);
        return (func, x1) -> this.compute(t, x);
    }
}

