/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.world;

import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionUtil {
    public static final Logger LOGGER = LogManager.getLogger();

    public static boolean tryConnect(BlockPos startPos, BlockPos endPos) {
        if (startPos.func_177956_o() == endPos.func_177956_o()) {
            return true;
        }
        if (GSKOMathUtil.distanceOf3D(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p(), endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p()) == 0.0) {
            return false;
        }
        return false;
    }

    public static int getSegCount(BlockPos startPosIn, BlockPos endPosIn) {
        if (startPosIn == null || endPosIn == null) {
            LOGGER.warn("Invalid Block Positions: {} , {}", (Object)startPosIn, (Object)endPosIn);
            return 0;
        }
        return (int)(GSKOMathUtil.distanceOf3D(startPosIn.func_177958_n(), startPosIn.func_177956_o(), startPosIn.func_177952_p(), endPosIn.func_177958_n(), endPosIn.func_177956_o(), endPosIn.func_177952_p()) / 3.0);
    }

    public static BlockPos.Mutable getSegPositions() {
        return null;
    }

    public static List<Double> getSegRotations() {
        return new ArrayList<Double>();
    }

    public static Pair<Vector3d, Vector3d> getPosAndRot(Vector3d startPos, Vector3d intersection, Vector3d endPos, float time) {
        Vector3d segPos = GSKOMathUtil.bezier2(startPos, intersection, endPos, time);
        return new Pair((Object)segPos, (Object)new Vector3d(1.0, 1.0, 1.0));
    }

    public static void connectRail(Vector3d startPos, Vector3d intersection, Vector3d endPos, float time) {
        Pair<Vector3d, Vector3d> pair = ConnectionUtil.getPosAndRot(startPos, intersection, endPos, time);
    }
}

