/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.world;

import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.TreeFeature;

public class FeatureUtil {
    public static void fillEllipse(IWorldGenerationReader reader, BlockPos center, Random random, BlockStateProvider state, int radiusX, int radiusZ) {
        for (int x = center.func_177958_n() - radiusX; x <= center.func_177958_n() + radiusX; ++x) {
            for (int z = center.func_177952_p() - radiusX; z <= center.func_177952_p() + radiusX; ++z) {
                if (!FeatureUtil.isInsideCircle(x, center.func_177956_o(), z, center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), radiusX)) continue;
                BlockPos pos = new BlockPos(x, center.func_177956_o(), z);
                FeatureUtil.placeBlock(reader, pos, random, state);
            }
        }
    }

    public static void fillEllipse(IWorldGenerationReader reader, BlockPos center, Random random, BlockStateProvider state, int radius, boolean ignoreTrunk) {
        for (int x = center.func_177958_n() - radius; x <= center.func_177958_n() + radius; ++x) {
            for (int z = center.func_177952_p() - radius; z <= center.func_177952_p() + radius; ++z) {
                if (!FeatureUtil.isInsideCircle(x, center.func_177956_o(), z, center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), radius)) continue;
                BlockPos pos = new BlockPos(x, center.func_177956_o(), z);
                if (ignoreTrunk) {
                    FeatureUtil.placeFoliage(reader, pos, random, state);
                    continue;
                }
                FeatureUtil.placeBlock(reader, pos, random, state);
            }
        }
    }

    public static boolean isInsideCircle(int x, int y, int z, int centerX, int centerY, int centerZ, int radius) {
        return Math.pow(x - centerX, 2.0) + Math.pow(y - centerY, 2.0) + Math.pow(z - centerZ, 2.0) <= Math.pow(radius, 2.0);
    }

    public static boolean isInsideEllipse(int x, int y, int z, int centerX, int centerY, int centerZ, int semiMajorAxis, int semiMinorAxis, int verticalAxis) {
        return Math.pow(x - centerX, 2.0) / Math.pow(semiMajorAxis, 2.0) + Math.pow(y - centerY, 2.0) / Math.pow(verticalAxis, 2.0) + Math.pow(z - centerZ, 2.0) / Math.pow(semiMinorAxis, 2.0) <= 1.0;
    }

    public static BlockPos translate(BlockPos pos, double distance, double angle, double tilt) {
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        return pos.func_177963_a((double)Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance), (double)Math.round(Math.cos(rtilt) * distance), (double)Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
    }

    private static void placeTrunk(IWorldGenerationReader reader, BlockPos pos, Random random, BlockStateProvider state) {
        BlockState trunkState = state.func_225574_a_(random, pos);
        reader.func_180501_a(pos, trunkState, 3);
    }

    private static void placeBlock(IWorldGenerationReader reader, BlockPos pos, Random random, BlockStateProvider state) {
        reader.func_180501_a(pos, state.func_225574_a_(random, pos), 3);
    }

    private static void placeFoliage(IWorldGenerationReader reader, BlockPos pos, Random random, BlockStateProvider state) {
        if (!FeatureUtil.isTrunkBlockAt((IWorldGenerationBaseReader)reader, pos) && !TreeFeature.func_236404_a_((IWorldGenerationBaseReader)reader, (BlockPos)pos)) {
            return;
        }
        reader.func_180501_a(pos, state.func_225574_a_(random, pos), 3);
    }

    public static boolean isTrunkBlockAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    public static void placeDiagonalTrunks(IWorldGenerationReader reader, Random random, BlockPos start, BlockStateProvider state, int width, int height) {
        BlockPos end = new BlockPos(start.func_177958_n() + width, start.func_177956_o() + height, 0);
        float distance = start.func_218139_n((Vector3i)end);
        for (int i = 0; i < (int)distance; ++i) {
            BlockPos pos = GSKOMathUtil.lerp((float)i / distance, start, end);
            FeatureUtil.placeBlock(reader, pos, random, state);
        }
    }

    public static void placeTrunkPattern(ISeedReader reader, Random random, BlockPos start, BlockStateProvider state) {
        int chance = GSKOMathUtil.randomRange(1, 2);
        switch (chance) {
            case 1: {
                int t1 = GSKOMathUtil.randomRange(2, 3);
                BlockPos pos1 = FeatureUtil.randomOffset(start);
                for (int i = 0; i < t1; ++i) {
                    FeatureUtil.placeCrossPattern(reader, random, pos1.func_177981_b(i), state);
                }
                break;
            }
            default: {
                int t2 = GSKOMathUtil.randomRange(2, 3);
                BlockPos pos2 = FeatureUtil.randomOffset(start);
                for (int i = 0; i < t2; ++i) {
                    FeatureUtil.place2b2Pattern(reader, random, pos2.func_177981_b(i), state);
                }
            }
        }
    }

    public static BlockPos randomOffset(BlockPos pos) {
        int chance = GSKOMathUtil.randomRange(1, 4);
        switch (chance) {
            default: {
                return new BlockPos((Vector3i)pos.func_177974_f());
            }
            case 2: {
                return new BlockPos((Vector3i)pos.func_177968_d());
            }
            case 3: {
                return new BlockPos((Vector3i)pos.func_177978_c());
            }
            case 4: 
        }
        return new BlockPos((Vector3i)pos.func_177976_e());
    }

    public static void placeCrossPattern(ISeedReader reader, Random random, BlockPos start, BlockStateProvider state) {
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start, random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177965_g(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177970_e(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177985_f(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177964_d(1), random, state);
    }

    public static void place2b2Pattern(ISeedReader reader, Random random, BlockPos start, BlockStateProvider state) {
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start, random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177985_f(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177970_e(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, (BlockPos)start.func_239590_i_().func_196234_d(1, 0, 1), random, state);
    }

    public static void placeCornerPattern(ISeedReader reader, Random random, BlockPos start, BlockStateProvider state) {
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start, random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177985_f(1), random, state);
        FeatureUtil.placeBlock((IWorldGenerationReader)reader, start.func_239590_i_().func_177970_e(1), random, state);
    }

    public static void placeStraightBlocks(IWorldGenerationReader reader, Random random, BlockPos start, BlockStateProvider state, int height) {
        for (int i = 0; i < height; ++i) {
            FeatureUtil.placeBlock(reader, new BlockPos(start.func_177958_n(), start.func_177956_o() + i, start.func_177952_p()), random, state);
        }
    }

    public static void makeLeafSpheroid(IWorldGenerationReader world, Random random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider state, Set<BlockPos> leaves) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeatureUtil.placeLeafBlock(world, random, centerPos, state, leaves);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, 0, z), state, leaves);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, 0, -z), state, leaves);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, 0, x), state, leaves);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, 0, -x), state, leaves);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, y2, z), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, y2, -z), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, y2, x), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, y2, -x), state, leaves);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, -y2, z), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, -y2, -z), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, -y2, x), state, leaves);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, -y2, -x), state, leaves);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void makeLeafSpheroid(IWorldGenerationReader world, Random random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider state) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeatureUtil.placeLeafBlock(world, random, centerPos, state);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state);
                FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, 0, z), state);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, 0, -z), state);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, 0, x), state);
                    FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, 0, -x), state);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, y2, z), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, y2, -z), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, y2, x), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, y2, -x), state);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(x, -y2, z), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-x, -y2, -z), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(-z, -y2, x), state);
                            FeatureUtil.placeLeafBlock(world, random, centerPos.func_177982_a(z, -y2, -x), state);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeLeafBlock(IWorldGenerationReader world, Random random, BlockPos pos, BlockStateProvider state, Set<BlockPos> leavesPos) {
        if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            return;
        }
        world.func_180501_a(pos, state.func_225574_a_(random, pos), 3);
        leavesPos.add(pos.func_185334_h());
    }

    public static void placeLeafBlock(IWorldGenerationReader world, Random random, BlockPos pos, BlockStateProvider state) {
        if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            return;
        }
        world.func_180501_a(pos, state.func_225574_a_(random, pos), 3);
    }

    public boolean isBoundaryBiome(Biome centerBiome, Biome surroundBiome) {
        return centerBiome.getRegistryName() == null && surroundBiome.getRegistryName() == null && centerBiome.getRegistryName().equals((Object)surroundBiome.getRegistryName()) && centerBiome.getRegistryName().equals((Object)new ResourceLocation("gensokyoontology", "youkai_mountain"));
    }

    public static Direction getValidDirection(ISeedReader reader, BlockPos blockPos, Set<Block> blocks) {
        return FeatureUtil.getValidDirection(reader, blockPos, blocks, 1);
    }

    public static Direction getValidDirection(ISeedReader reader, BlockPos blockPos, Set<Block> blocks, int count) {
        for (int i = 0; i < count; ++i) {
            if (blocks.contains(reader.func_180495_p(blockPos.func_177965_g(i)).func_177230_c())) {
                return Direction.EAST;
            }
            if (blocks.contains(reader.func_180495_p(blockPos.func_177970_e(i)).func_177230_c())) {
                return Direction.SOUTH;
            }
            if (blocks.contains(reader.func_180495_p(blockPos.func_177985_f(i)).func_177230_c())) {
                return Direction.WEST;
            }
            if (!blocks.contains(reader.func_180495_p(blockPos.func_177964_d(i)).func_177230_c())) continue;
            return Direction.NORTH;
        }
        return Direction.UP;
    }

    public static BlockPos[] getBresenhamArrays(BlockPos src, BlockPos dest) {
        return FeatureUtil.getBresenhamArrays(src.func_177958_n(), src.func_177956_o(), src.func_177952_p(), dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p());
    }

    public static BlockPos[] getBresenhamArrays(int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos[] lineArray;
        BlockPos pixel = new BlockPos(x1, y1, z1);
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int absDx = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int absDy = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int absDz = Math.abs(dz);
        int doubleAbsDx = absDx << 1;
        int doubleAbsDy = absDy << 1;
        int doubleAbsDz = absDz << 1;
        if (absDx >= absDy && absDx >= absDz) {
            int err_1 = doubleAbsDy - absDx;
            int err_2 = doubleAbsDz - absDx;
            lineArray = new BlockPos[absDx + 1];
            for (int i = 0; i < absDx; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDx;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDx;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177965_g(x_inc);
            }
        } else if (absDy >= absDx && absDy >= absDz) {
            int err_1 = doubleAbsDx - absDy;
            int err_2 = doubleAbsDz - absDy;
            lineArray = new BlockPos[absDy + 1];
            for (int i = 0; i < absDy; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_1 -= doubleAbsDy;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDy;
                }
                err_1 += doubleAbsDx;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177981_b(y_inc);
            }
        } else {
            int err_1 = doubleAbsDy - absDz;
            int err_2 = doubleAbsDx - absDz;
            lineArray = new BlockPos[absDz + 1];
            for (int i = 0; i < absDz; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDz;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_2 -= doubleAbsDz;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDx;
                pixel = pixel.func_177970_e(z_inc);
            }
        }
        lineArray[lineArray.length - 1] = pixel;
        return lineArray;
    }
}

