/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.util.world;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraftforge.common.BiomeManager;

public enum VanillaClimate implements IStringSerializable
{
    HOT(BiomeManager.BiomeType.DESERT),
    HOT_LEGACY(BiomeManager.BiomeType.DESERT_LEGACY),
    WARM(BiomeManager.BiomeType.WARM),
    COOL(BiomeManager.BiomeType.COOL),
    COLD(BiomeManager.BiomeType.ICY);

    private static final Map<String, String> OLD_TO_NEW_NAME;
    private final BiomeManager.BiomeType climate;

    private VanillaClimate(BiomeManager.BiomeType climate) {
        this.climate = climate;
    }

    public static VanillaClimate byName(String name) {
        name = OLD_TO_NEW_NAME.getOrDefault(name.toUpperCase(), name.toUpperCase());
        return VanillaClimate.valueOf(name.toUpperCase());
    }

    public BiomeManager.BiomeType getClimate() {
        return this.climate;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name();
    }

    static {
        OLD_TO_NEW_NAME = (Map)Util.func_200696_a(new HashMap(), map -> {
            map.put("DESERT", "HOT");
            map.put("DESERT_LEGACY", "HOT_LEGACY");
            map.put("WARM", "WARM");
            map.put("COOL", "COOL");
            map.put("ICY", "COLD");
        });
    }
}

