/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world;

import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;

public class GSKOEntityGenerator {
    @SafeVarargs
    public static void addEntityExceptBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Objects::toString).anyMatch(obj -> obj.equals(event.getName().toString()));
        if (!isSelected) {
            GSKOEntityGenerator.addEntityGeneration(event, type, weight, minCount, maxCount);
        }
    }

    @SafeVarargs
    public static void addEntityToBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Objects::toString).anyMatch(obj -> obj.equals(event.getName().toString()));
        if (isSelected) {
            GSKOEntityGenerator.addEntityGeneration(event, type, weight, minCount, maxCount);
        }
    }

    public static void addEntityToGensokyo(BiomeLoadingEvent event, EntityType<?> entity, int weight, int minCount, int maxCount) {
        if (GSKOBiomes.isGensokyoBiome(event)) {
            GSKOEntityGenerator.addEntityGeneration(event, entity, weight, minCount, maxCount);
        }
    }

    public static void addEntityGeneration(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        List spawners = event.getSpawns().getSpawner(type.func_220339_d());
        spawners.add(new MobSpawnInfo.Spawners(type, weight, minCount, maxCount));
    }

    public static void trySpawnLilyWhite(WorldEvent.PotentialSpawns event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            Random random = new Random();
            ResourceLocation biomeRegistryName = serverWorld.func_226691_t_(event.getPos()).getRegistryName();
            if (random.nextInt(100) == 0 && biomeRegistryName != null && biomeRegistryName.equals((Object)GSKOBiomes.HAKUREI_SHRINE_PRECINCTS_KEY.getRegistryName()) && serverWorld.getEntities().noneMatch(entity -> entity.func_200600_R() == EntityRegistry.LILY_WHITE_ENTITY.get())) {
                EntityType entityType = (EntityType)EntityRegistry.LILY_WHITE_ENTITY.get();
                entityType.func_220331_a(serverWorld, null, null, event.getPos(), SpawnReason.EVENT, false, false);
            }
        }
    }
}

