/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world;

import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.common.tileentity.GapTileEntity;
import github.thelawf.gensokyoontology.core.init.BlockRegistry;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.logging.log4j.LogManager;

public class TeleportHelper {
    public static void teleport(ServerPlayerEntity player, final ServerWorld destination, final BlockPos pos) {
        if (TeleportHelper.canTeleport(destination, pos)) {
            player.changeDimension(destination, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    BlockPos validPos = (BlockPos)TeleportHelper.findValidPos(destination, pos).getSecond();
                    entity = repositionEntity.apply(false);
                    entity.func_70107_b((double)validPos.func_177958_n(), (double)validPos.func_177956_o(), (double)validPos.func_177952_p());
                    return entity;
                }
            });
        }
    }

    public static void applyGapTeleport(final ServerPlayerEntity player, ServerWorld destination, final GapTileEntity gapTile) {
        final BlockPos pos = gapTile.getDestinationPos();
        player.changeDimension(destination, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
                gapTile.setCooldown(400);
                return player;
            }
        });
    }

    public static void applyStructureTeleport(ServerWorld destination) {
    }

    public static boolean canTeleport(ServerWorld destination, BlockPos pos) {
        if (destination == null) {
            return false;
        }
        BlockPos lowerPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
        BlockPos upperPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        BlockState eyeBlock = destination.func_180495_p(upperPos);
        BlockState playerBlock = destination.func_180495_p(pos);
        BlockState standBlock = destination.func_180495_p(lowerPos);
        if (eyeBlock.equals(Blocks.field_150350_a.func_176223_P()) && playerBlock.equals(Blocks.field_150350_a.func_176223_P())) {
            if (standBlock.func_177230_c().equals(Blocks.field_150350_a)) {
                destination.func_175656_a(lowerPos, ((Block)BlockRegistry.SAKURA_PLANKS.get()).func_176223_P());
                LogManager.getLogger().info("Position Valid");
                return true;
            }
            if (standBlock.func_177230_c() instanceof IFluidBlock) {
                destination.func_175656_a(lowerPos, ((Block)BlockRegistry.SAKURA_PLANKS.get()).func_176223_P());
                LogManager.getLogger().info("Stand Position Has Fluids");
                return true;
            }
            return TeleportHelper.isValidPos(destination, pos);
        }
        if (standBlock.func_177230_c().equals(Blocks.field_150350_a)) {
            return TeleportHelper.clearAndSetBlocks(destination, pos);
        }
        return TeleportHelper.clearBlocks(destination, pos);
    }

    private static boolean clearAndSetBlocks(ServerWorld destination, BlockPos pos) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        BlockState sakuraPlanks = ((Block)BlockRegistry.SAKURA_PLANKS.get()).func_176223_P();
        destination.func_175656_a(pos, air);
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(x, pos.func_177956_o(), z), sakuraPlanks);
                destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(-x, pos.func_177956_o(), -z), sakuraPlanks);
                for (int y = 0; y < 2; ++y) {
                    destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(x, y, z), air);
                    destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(-x, y, -z), air);
                }
            }
        }
        return true;
    }

    private static boolean clearBlocks(ServerWorld destination, BlockPos pos) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        destination.func_175656_a(pos, air);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(i, j, k), air);
                    destination.func_175656_a((BlockPos)pos.func_239590_i_().func_196234_d(-i, j, -k), air);
                }
            }
        }
        return true;
    }

    private static boolean isValidPos(ServerWorld destination, BlockPos pos) {
        LogManager.getLogger().info("Other Condition is: " + TeleportHelper.findValidPos(destination, pos).getFirst());
        return (Boolean)TeleportHelper.findValidPos(destination, pos).getFirst();
    }

    private static Pair<Boolean, BlockPos> findValidPos(ServerWorld destination, BlockPos pos) {
        for (int i = 0; i < 255; ++i) {
            BlockPos playerPos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            BlockPos standPos = new BlockPos(pos.func_177977_b().func_177958_n(), i, pos.func_177977_b().func_177952_p());
            BlockPos eyePos = new BlockPos(pos.func_177984_a().func_177958_n(), i, pos.func_177984_a().func_177952_p());
            if (destination.func_180495_p(standPos).func_177230_c().equals(Blocks.field_150350_a) || !destination.func_180495_p(playerPos).func_177230_c().equals(Blocks.field_150350_a) || !destination.func_180495_p(eyePos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            return Pair.of((Object)true, (Object)playerPos);
        }
        return Pair.of((Object)false, (Object)pos);
    }

    private static boolean isInSameDimension(RegistryKey<World> departureWorld, RegistryKey<World> destination) {
        return departureWorld == destination;
    }
}

