/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.dimension.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;

public final class GSKOBiomeMaker {
    private static BiomeGenerationSettings.Builder withBuilder(BiomeGenerationSettings.Builder settings) {
        BiomeGenerationSettings.Builder biomegenerationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationSettings);
        return biomegenerationSettings;
    }

    private static BiomeGenerationSettings.Builder withBuilder(BiomeGenerationSettings.Builder settings, List<FeatureType> features) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)settings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)settings);
        features.forEach(f -> {
            if (features.contains((Object)FeatureType.PUMPKINS)) {
                DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)settings);
            }
            if (features.contains((Object)FeatureType.FOREST_GRASS)) {
                DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)settings);
            }
            if (features.contains((Object)FeatureType.ACACIA_TREE)) {
                DefaultBiomeFeatures.func_243687_A((BiomeGenerationSettings.Builder)settings);
            }
            if (features.contains((Object)FeatureType.PLAINS_GRASS)) {
                DefaultBiomeFeatures.func_243704_R((BiomeGenerationSettings.Builder)settings);
            }
            if (features.contains((Object)FeatureType.NORMAL_GRASS_PATCH)) {
                DefaultBiomeFeatures.func_243697_K((BiomeGenerationSettings.Builder)settings);
            }
        });
        return settings;
    }

    private static BiomeGenerationSettings.Builder defaultBuilder() {
        BiomeGenerationSettings.Builder biomegenerationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationSettings);
        return biomegenerationSettings;
    }

    private static BiomeGenerationSettings.Builder makeCustomSurface(Supplier<ConfiguredSurfaceBuilder<?>> builder) {
        return new BiomeGenerationSettings.Builder().func_242519_a(builder).func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a);
    }

    @SafeVarargs
    public static BiomeGenerationSettings.Builder withBuilder(Pair<GenerationStage.Decoration, ConfiguredFeature<?, ?>> ... features) {
        BiomeGenerationSettings.Builder builder = GSKOBiomeMaker.defaultBuilder();
        for (Pair<GenerationStage.Decoration, ConfiguredFeature<?, ?>> pair : features) {
            builder.func_242513_a((GenerationStage.Decoration)pair.getFirst(), (ConfiguredFeature)pair.getSecond());
        }
        return builder;
    }

    public static Biome makeMagicForest() {
        return (Biome)new Biome.Builder().func_205421_a(0.08f).func_205420_b(0.08f).func_205417_d(0.75f).func_205414_c(0.65f).func_205419_a(Biome.Category.FOREST).func_205415_a(Biome.RainType.RAIN).func_242458_a(MobSpawnInfo.field_242551_b).func_242457_a(GSKOBiomeMaker.withBuilder(Pair.of((Object)GenerationStage.Decoration.VEGETAL_DECORATION, (Object)Features.field_243926_ci)).func_242508_a()).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(894934).func_235248_c_(2633348).func_235239_a_(12638463).func_242539_d(GSKOBiomeMaker.getSkyColor(0.7f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242455_a().setRegistryName("magic_forest");
    }

    public static Biome makeUntroddenValley(Supplier<ConfiguredSurfaceBuilder<?>> builder) {
        return new Biome.Builder().func_205421_a(-0.35f).func_205420_b(0.12f).func_205417_d(0.6f).func_205414_c(0.95f).func_205419_a(Biome.Category.RIVER).func_205415_a(Biome.RainType.RAIN).func_242458_a(MobSpawnInfo.field_242551_b).func_242457_a(GSKOBiomeMaker.withBuilder(GSKOBiomeMaker.makeCustomSurface(builder)).func_242508_a()).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(894934).func_235248_c_(2633348).func_235239_a_(12638463).func_242539_d(GSKOBiomeMaker.getSkyColor(0.7f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242455_a();
    }

    public static Biome makeYatsugaTakeBiome(Supplier<ConfiguredSurfaceBuilder<?>> builder) {
        ArrayList<FeatureType> features = new ArrayList<FeatureType>();
        features.add(FeatureType.ACACIA_TREE);
        features.add(FeatureType.NORMAL_GRASS_PATCH);
        return new Biome.Builder().func_205421_a(2.8f).func_205420_b(1.5f).func_205417_d(0.2f).func_205414_c(0.6f).func_205419_a(Biome.Category.EXTREME_HILLS).func_205415_a(Biome.RainType.SNOW).func_242458_a(MobSpawnInfo.field_242551_b).func_242456_a(Biome.TemperatureModifier.NONE).func_242457_a(GSKOBiomeMaker.withBuilder(GSKOBiomeMaker.makeCustomSurface(builder), features).func_242508_a()).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(894934).func_235248_c_(2633348).func_235239_a_(12638463).func_242539_d(GSKOBiomeMaker.getSkyColor(0.7f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242455_a();
    }

    private static int getSkyColor(float temperature) {
        float shift = MathHelper.func_76131_a((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - shift * 0.05f), (float)(0.5f + shift * 0.1f), (float)1.0f);
    }

    public static enum FeatureType {
        OAK_TREE,
        FANCY_OAK_TREE,
        ACACIA_TREE,
        SAKURA_TREE,
        BAMBOO,
        LYCORIS,
        SUNFLOWER,
        PUMPKINS,
        FOREST_GRASS,
        PLAINS_GRASS,
        NORMAL_GRASS_PATCH;

    }
}

