/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.dimension.biome;

import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomeMaker;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomesProvider;
import github.thelawf.gensokyoontology.common.world.surface.GSKOConfiguredSurface;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class GSKOBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"gensokyoontology");
    public static final RegistryObject<Biome> YATSUGA_TAKE_BIOME = BIOMES.register("mountain_yatsugatake", () -> GSKOBiomeMaker.makeYatsugaTakeBiome(() -> GSKOConfiguredSurface.YATSUGA_TAKE));
    public static final RegistryKey<Biome> UNTRODDEN_VALLEY_KEY = GSKOBiomes.makeKey("untrodden_valley");
    public static final RegistryKey<Biome> GSKO_FOREST_KEY = GSKOBiomes.makeKey("gensokyo_forest");
    public static final RegistryKey<Biome> GSKO_PLAINS_KEY = GSKOBiomes.makeKey("gensokyo_plains");
    public static final RegistryKey<Biome> GSKO_RIVER_KEY = GSKOBiomes.makeKey("gensokyo_river");
    public static final RegistryKey<Biome> HAKUREI_SHRINE_PRECINCTS_KEY = GSKOBiomes.makeKey("hakurei_shrine_precincts");
    public static final RegistryKey<Biome> SCARLET_MANSION_PRECINCTS_KEY = GSKOBiomes.makeKey("scarlet_mansion_precincts");
    public static final RegistryKey<Biome> BEAST_PATH_KEY = GSKOBiomes.makeKey("beast_path");
    public static final RegistryKey<Biome> YOUKAI_JUKAI_KEY = GSKOBiomes.makeKey("youkai_jukai");
    public static final RegistryKey<Biome> YOUKAI_MOUNTAIN_KEY = GSKOBiomes.makeKey("youkai_mountain");
    public static final RegistryKey<Biome> SUNFLOWER_GARDEN_KEY = GSKOBiomes.makeKey("sunflower_garden");
    public static final RegistryKey<Biome> BAMBOO_FOREST_LOST_KEY = GSKOBiomes.makeKey("bamboo_forest_of_lost");
    public static final RegistryKey<Biome> MAGIC_FOREST_KEY = GSKOBiomes.makeKey("magic_forest");
    public static final RegistryKey<Biome> DOLL_FOREST_KEY = GSKOBiomes.makeKey("doll_forest");
    public static final RegistryKey<Biome> NAMELESS_HILL_KEY = GSKOBiomes.makeKey("nameless_hill");
    public static final RegistryKey<Biome> MUENZUKA = GSKOBiomes.makeKey("muenzuka");
    public static final RegistryKey<Biome> HUMAN_VILLAGE_KEY = GSKOBiomes.makeKey("human_village");
    public static final RegistryKey<Biome> MISTY_LAKE_KEY = GSKOBiomes.makeKey("misty_lake");
    public static final RegistryKey<Biome> SANZU_RIVER_KEY = GSKOBiomes.makeKey("sanzu_river");
    public static final RegistryKey<Biome> HIGAN_KEY = GSKOBiomes.makeKey("higan");
    public static final RegistryKey<Biome> WIND_GODDESS_LAKE_KEY = GSKOBiomes.makeKey("wind_goddess_lake");
    public static final RegistryKey<Biome> YOUKAI_TANUKI_FOREST = GSKOBiomes.makeKey("youkai_tanuki_forest");
    public static final RegistryKey<Biome> LETHE_RIVER_BANK_KEY = GSKOBiomes.makeKey("lethe_river_bank");
    public static final RegistryKey<Biome> FAKE_HEAVEN_SHELF_KEY = GSKOBiomes.makeKey("fake_heaven_shelf");
    public static final RegistryKey<Biome> FORMER_HELL_KEY = GSKOBiomes.makeKey("former_hell");
    public static final RegistryKey<Biome> FORMER_CAPITAL_KEY = GSKOBiomes.makeKey("former_capital");
    public static final RegistryKey<Biome> CHIREIDEN_REGION_KEY = GSKOBiomes.makeKey("chireiden");
    public static final RegistryKey<Biome> BLAZING_HELL_RUINS_KEY = GSKOBiomes.makeKey("blazing_hell_ruins_key");
    public static final RegistryKey<Biome> NETHER_VOID_KEY = GSKOBiomes.makeKey("nether_void");
    public static final RegistryKey<Biome> NETHER_LAND_KEY = GSKOBiomes.makeKey("nether_land");
    public static final RegistryKey<Biome> NETHER_SAKURA_FOREST_KEY = GSKOBiomes.makeKey("nether_sakura_forest");

    public static boolean isGensokyoBiome(BiomeLoadingEvent event) {
        return GSKOBiomesProvider.GSKO_BIOMES.stream().map(RegistryKey::func_240901_a_).map(Objects::toString).anyMatch(obj -> obj.equals(event.getName().toString()));
    }

    private static RegistryKey<Biome> makeKey(String name) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("gensokyoontology", name));
    }

    public static RegistryKey<Biome> createBiomeKey(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(biome.getRegistryName()));
    }
}

