/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.dimension.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.common.world.layer.GSKOLayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import org.jetbrains.annotations.Nullable;

public class GSKOBiomesProvider
extends BiomeProvider {
    final long seed;
    public static final List<Biome> biomes = new ArrayList<Biome>();
    private final Layer layer;
    private final Registry<Biome> biomeRegistry;
    public static final Codec<GSKOBiomesProvider> GSKO_BIOME_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(provider -> provider.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(o -> o.biomeRegistry)).apply((Applicative)instance, instance.stable(GSKOBiomesProvider::new)));
    public static final List<RegistryKey<Biome>> GSKO_BIOMES = ImmutableList.of(GSKOBiomes.SCARLET_MANSION_PRECINCTS_KEY, GSKOBiomes.HAKUREI_SHRINE_PRECINCTS_KEY, GSKOBiomes.BAMBOO_FOREST_LOST_KEY, GSKOBiomes.WIND_GODDESS_LAKE_KEY, GSKOBiomes.SUNFLOWER_GARDEN_KEY, GSKOBiomes.UNTRODDEN_VALLEY_KEY, GSKOBiomes.YOUKAI_MOUNTAIN_KEY, GSKOBiomes.NAMELESS_HILL_KEY, GSKOBiomes.HUMAN_VILLAGE_KEY, GSKOBiomes.MAGIC_FOREST_KEY, GSKOBiomes.SANZU_RIVER_KEY, GSKOBiomes.MISTY_LAKE_KEY, (Object[])new RegistryKey[]{GSKOBiomes.HIGAN_KEY, GSKOBiomes.MUENZUKA, GSKOBiomes.GSKO_RIVER_KEY});

    public GSKOBiomesProvider(long seed, Registry<Biome> biomeRegistry) {
        super(GSKO_BIOMES.stream().map(key -> () -> (Biome)biomeRegistry.func_243576_d(key)));
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        this.layer = GSKOLayerUtil.makeGSKOLayers(seed, biomeRegistry);
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return GSKO_BIOME_CODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return this;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.layer.func_242936_a(this.biomeRegistry, x, z);
    }

    @Nonnull
    public Set<BlockState> func_205706_b() {
        return super.func_205706_b();
    }

    @Nullable
    public BlockPos func_225531_a_(int xIn, int yIn, int zIn, int radiusIn, Predicate<Biome> biomesIn, Random randIn) {
        return super.func_225531_a_(xIn, yIn, zIn, radiusIn, biomesIn, randIn);
    }

    public static void register() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("gensokyoontology", "gsko_biome_provider"), GSKO_BIOME_CODEC);
    }

    public static int getBiomeID(RegistryKey<Biome> biome, Registry<Biome> registry) {
        return registry.func_148757_b(registry.func_230516_a_(biome));
    }
}

