/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature;

import github.thelawf.gensokyoontology.common.world.GSKOOreType;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.common.world.feature.GSKOFeatures;
import github.thelawf.gensokyoontology.common.world.feature.config.GSKOWGConfigs;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class GSKOFeatureGenerator {
    public static void generateOverworldTrees(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
    }

    public static void generateGensokyoTrees(BiomeLoadingEvent event) {
        List base;
        if (event.getName() == null) {
            return;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        if (types.contains(GSKOBiomes.GSKO_FOREST_KEY)) {
            base = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            base.add(() -> GSKOFeatures.SAKURA_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.15f, 2))));
            base.add(() -> Features.field_243869_bO.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.15f, 2))));
        }
        if (event.getName().equals((Object)GSKOBiomes.BAMBOO_FOREST_LOST_KEY.getRegistryName())) {
            base = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            base.add(() -> Features.field_243915_cH.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.9f, 2))));
        }
    }

    public static void generateFlowers(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
        if (types.contains(BiomeDictionary.Type.WET) || types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.SWAMP)) {
            List base = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            base.add(() -> GSKOFeatures.HIGAN_LYCORIS);
        }
    }

    public static void generateHerbPlants(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
        if (types.contains(BiomeDictionary.Type.FOREST)) {
            List base = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            base.add(() -> GSKOFeatures.WASABI);
        }
    }

    public static void generateOverworldOre(BiomeLoadingEvent event) {
        GSKOOreType ore = GSKOOreType.IZANO_OBJECT;
        OreFeatureConfig config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ore.getLazyBlock().get()).func_176223_P(), ore.getMaxVeinSize());
        ConfiguredFeature<?, ?> izanoOreFeature = GSKOFeatures.makeIzanoOreFeature(ore, config);
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, izanoOreFeature);
    }

    public static void generateGensokyoOre(BiomeLoadingEvent event) {
        if (event.getName() != null && event.getName().func_110624_b().equals("gensokyoontology")) {
            ConfiguredFeature<?, ?> jadeOreFeature = GSKOFeatures.makeOreFeature(GSKOOreType.JADE_GENSOKYO, (Feature<OreFeatureConfig>)Feature.field_236289_V_, GSKOWGConfigs.JADE_GENSOKYO_CONFIG, GSKOWGConfigs.JADE_GENSOKYO_PLANCEMENT);
            ConfiguredFeature<?, ?> dragonSphereOreFeature = GSKOFeatures.makeOreFeature(GSKOOreType.DRAGON_SPHERE, (Feature<OreFeatureConfig>)Feature.field_236289_V_, GSKOWGConfigs.DRAGON_SPHERE_CONFIG, GSKOWGConfigs.DRAGON_SPHERE_PLACEMENT);
            ConfiguredFeature<?, ?> immemorialAlloyFeature = GSKOFeatures.makeOreFeature(GSKOOreType.IMMEMORIAL_ALLOY, (Feature<OreFeatureConfig>)Feature.field_236289_V_, GSKOWGConfigs.CRIMSON_ALLOY_CONFIG, GSKOWGConfigs.IMMEMORIAL_ALLOY_PLACEMENT);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, jadeOreFeature);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, dragonSphereOreFeature);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, immemorialAlloyFeature);
        }
    }

    public static void generateOre(BiomeLoadingEvent event, GSKOOreType ore) {
        OreFeatureConfig config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ore.getLazyBlock().get()).func_176223_P(), ore.getMaxVeinSize());
        ConfiguredPlacement placement = Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(ore.getMinHeight(), ore.getMinHeight(), ore.getMaxHeight()));
        ConfiguredFeature<?, ?> oreFeature = GSKOFeatures.makeOreFeature(ore, (Feature<OreFeatureConfig>)Feature.field_236289_V_, config, placement);
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, oreFeature);
    }

    public static void generateGSKOStructures(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        ResourceLocation bambooForestOfLost = new ResourceLocation("gensokyoontology", "bamboo_forest_of_lost");
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
        if (biomeKey.getRegistryName().equals((Object)bambooForestOfLost)) {
            List features = event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES);
            features.add(() -> GSKOFeatures.WATERFALL);
        }
    }

    public static void generateOverworldStructures(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
    }

    public static void addWaterfall(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        ResourceLocation bambooForestOfLost = new ResourceLocation("gensokyoontology", "bamboo_forest_of_lost");
        Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
        if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
            List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
            features.add(() -> GSKOFeatures.WATERFALL);
        }
    }
}

