/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.placer;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.thelawf.gensokyoontology.common.util.world.FeatureUtil;
import github.thelawf.gensokyoontology.common.world.feature.config.BranchesConfig;
import github.thelawf.gensokyoontology.core.PlacerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class BranchTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<BranchTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BranchTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.intRange((int)0, (int)24).fieldOf("branch_start_offset_down").forGetter(o -> o.branchDownwardOffset), (App)BranchesConfig.CODEC.fieldOf("branch_config").forGetter(o -> o.branchesConfig), (App)Codec.BOOL.fieldOf("perpendicular_branches").forGetter(o -> o.perpendicularBranches))).apply((Applicative)instance, BranchTrunkPlacer::new));
    private final int branchDownwardOffset;
    private final BranchesConfig branchesConfig;
    private final boolean perpendicularBranches;

    public BranchTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int branchDownwardOffset, BranchesConfig branchesConfig, boolean perpendicularBranches) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchDownwardOffset = branchDownwardOffset;
        this.branchesConfig = branchesConfig;
        this.perpendicularBranches = perpendicularBranches;
    }

    @NotNull
    protected TrunkPlacerType<BranchTrunkPlacer> func_230381_a_() {
        return PlacerRegistry.BRANCH_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int height, BlockPos startPos, Set<BlockPos> trunkBlocks, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        ArrayList leafBlocks = Lists.newArrayList();
        for (int y = 0; y <= height; ++y) {
            if (BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)startPos.func_177981_b(y), trunkBlocks, (MutableBoundingBox)mutableBoundingBox, (BaseTreeFeatureConfig)baseTreeFeatureConfig)) continue;
            height = y;
            break;
        }
        leafBlocks.add(new FoliagePlacer.Foliage(startPos.func_177981_b(height), 0, false));
        int numBranches = this.branchesConfig.branchCount + random.nextInt(this.branchesConfig.randomAddBranches + 1);
        float offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            BranchTrunkPlacer.buildBranch(world, startPos, trunkBlocks, leafBlocks, height - this.branchDownwardOffset + b, this.branchesConfig.length, this.branchesConfig.spacingYaw * (double)b + (double)offset, this.branchesConfig.downwardsPitch, random, mutableBoundingBox, baseTreeFeatureConfig, this.perpendicularBranches);
        }
        return leafBlocks;
    }

    private static void buildBranch(IWorldGenerationReader world, BlockPos pos, Set<BlockPos> trunkBlocks, List<FoliagePlacer.Foliage> leafBlocks, int height, double length, double angle, double tilt, Random treeRNG, MutableBoundingBox mbb, BaseTreeFeatureConfig config, boolean perpendicularBranches) {
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        if (perpendicularBranches) {
            BranchTrunkPlacer.drawBresenhamBranch(world, treeRNG, src, new BlockPos(dest.func_177958_n(), src.func_177956_o(), dest.func_177952_p()), trunkBlocks, mbb, config);
            int max = Math.max(src.func_177956_o(), dest.func_177956_o());
            for (int i = Math.min(src.func_177956_o(), dest.func_177956_o()); i < max + 1; ++i) {
                BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)treeRNG, (BlockPos)new BlockPos(dest.func_177958_n(), i, dest.func_177952_p()), trunkBlocks, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
            }
        } else {
            BranchTrunkPlacer.drawBresenhamBranch(world, treeRNG, src, dest, trunkBlocks, mbb, config);
        }
        BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)treeRNG, (BlockPos)dest.func_177974_f(), trunkBlocks, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)treeRNG, (BlockPos)dest.func_177976_e(), trunkBlocks, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)treeRNG, (BlockPos)dest.func_177968_d(), trunkBlocks, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)treeRNG, (BlockPos)dest.func_177978_c(), trunkBlocks, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        leafBlocks.add(new FoliagePlacer.Foliage(dest, 0, false));
    }

    private static void drawBresenhamBranch(IWorldGenerationReader world, Random random, BlockPos from, BlockPos to, Set<BlockPos> state, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        for (BlockPos pixel : FeatureUtil.getBresenhamArrays(from, to)) {
            BranchTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)pixel, state, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        }
    }
}

