/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.thelawf.gensokyoontology.common.util.world.FeatureUtil;
import github.thelawf.gensokyoontology.core.PlacerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class MagicTrunkPlacer
extends AbstractTrunkPlacer {
    private final int trunkWidth;
    private final int minHeight;
    public static final Codec<MagicTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("trunk_height").forGetter(o -> o.field_236906_d_), (App)Codec.INT.fieldOf("width").forGetter(o -> o.field_236907_e_), (App)Codec.INT.fieldOf("height").forGetter(o -> o.field_236908_f_), (App)Codec.INT.fieldOf("min_branch_height").forGetter(o -> o.minHeight), (App)Codec.INT.fieldOf("trunk_width").forGetter(o -> o.trunkWidth)).apply((Applicative)instance, MagicTrunkPlacer::new));

    public MagicTrunkPlacer(int baseTrunkHeight, int heightRandA, int heightRandB, int trunkWidth, int minHeight) {
        super(baseTrunkHeight, heightRandA, heightRandB);
        this.trunkWidth = trunkWidth;
        this.minHeight = minHeight;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return PlacerRegistry.MAGIC_TRUNK_PLACER;
    }

    @NotNull
    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader reader, Random random, int height, BlockPos startPos, Set<BlockPos> trunkBlocks, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        return this.generateTrunk(reader, random, startPos, trunkBlocks, bounds, config);
    }

    private List<FoliagePlacer.Foliage> generateTrunk(IWorldGenerationReader reader, Random random, BlockPos startPos, Set<BlockPos> trunkBlocks, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        ArrayList<FoliagePlacer.Foliage> foliages = new ArrayList<FoliagePlacer.Foliage>();
        for (int y = 0; y < this.field_236906_d_; ++y) {
            if (y <= this.field_236906_d_ / 2) {
                FeatureUtil.placeStraightBlocks(reader, random, startPos, config.field_227368_m_, this.field_236906_d_);
                continue;
            }
            this.generateBranch(reader, random, startPos, trunkBlocks, bounds, config);
            FeatureUtil.placeDiagonalTrunks(reader, random, startPos, config.field_227368_m_, this.trunkWidth, this.field_236906_d_);
        }
        foliages.add(new FoliagePlacer.Foliage(startPos.func_177981_b(this.field_236906_d_), 0, false));
        return foliages;
    }

    private void generateBranch(IWorldGenerationReader reader, Random random, BlockPos startPos, Set<BlockPos> trunkBlocks, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        FeatureUtil.placeDiagonalTrunks(reader, random, startPos, config.field_227368_m_, this.trunkWidth, this.minHeight);
    }
}

