/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.thelawf.gensokyoontology.common.util.world.FeatureUtil;
import github.thelawf.gensokyoontology.core.PlacerRegistry;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class SphericalFoliagePlacer
extends FoliagePlacer {
    public static final Codec<SphericalFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("horizontal_radius").forGetter(o -> Float.valueOf(o.horizontalRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("vertical_radius").forGetter(o -> Float.valueOf(o.verticalRadius)), (App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("offset").forGetter(obj -> obj.field_236750_g_), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_horizontal").orElse((Object)0).forGetter(o -> o.randomHorizontal), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_vertical").orElse((Object)0).forGetter(o -> o.randomVertical), (App)Codec.floatRange((float)-0.5f, (float)0.5f).fieldOf("vertical_filler_bias").orElse((Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.verticalBias)), (App)Codec.intRange((int)0, (int)256).fieldOf("shag_factor").orElse((Object)0).forGetter(o -> o.shag_factor)).apply((Applicative)instance, SphericalFoliagePlacer::new));
    private final float horizontalRadius;
    private final float verticalRadius;
    private final float verticalBias;
    private final int randomHorizontal;
    private final int randomVertical;
    private final int shag_factor;

    public SphericalFoliagePlacer(float horizontalRadius, float verticalRadius, FeatureSpread yOffset, int randomHorizontal, int randomVertical, float verticalBias, int shag_factor) {
        super(FeatureSpread.func_242252_a((int)((int)horizontalRadius)), yOffset);
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
        this.verticalBias = verticalBias;
        this.shag_factor = shag_factor;
    }

    protected FoliagePlacerType<SphericalFoliagePlacer> func_230371_a_() {
        return PlacerRegistry.SPHERICAL_FOLIAGE_PLACER;
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random random, BaseTreeFeatureConfig baseTreeFeatureConfig, int trunkHeight, FoliagePlacer.Foliage foliage, int foliageHeight, int radius, Set<BlockPos> leavesSet, int offset, MutableBoundingBox mutableBoundingBox) {
        BlockPos center = foliage.func_236763_a_().func_177981_b(offset);
        FeatureUtil.makeLeafSpheroid(world, random, center, (float)foliage.func_236764_b_() + this.horizontalRadius + (float)random.nextInt(this.randomHorizontal + 1), (float)foliage.func_236764_b_() + this.verticalRadius + (float)random.nextInt(this.randomVertical + 1), this.verticalBias, baseTreeFeatureConfig.field_227369_n_, leavesSet);
        if (this.shag_factor > 0) {
            for (int i = 0; i < this.shag_factor; ++i) {
                float TWO_PI = (float)Math.PI * 2;
                float randomYaw = random.nextFloat() * TWO_PI;
                float randomPitch = random.nextFloat() * 2.0f - 1.0f;
                float yUnit = MathHelper.func_76129_c((float)(1.0f - randomPitch * randomPitch));
                float xCircleOffset = yUnit * MathHelper.func_76134_b((float)randomYaw) * (this.horizontalRadius - 1.0f);
                float zCircleOffset = yUnit * MathHelper.func_76126_a((float)randomYaw) * (this.horizontalRadius - 1.0f);
                BlockPos placement = center.func_177963_a((double)(xCircleOffset + (float)((int)xCircleOffset >> 31)), (double)(randomPitch * (this.verticalRadius + 0.25f) + this.verticalBias), (double)(zCircleOffset + (float)((int)zCircleOffset >> 31)));
                this.placeLeafCluster(world, random, placement.func_185334_h(), baseTreeFeatureConfig.field_227369_n_, leavesSet);
            }
        }
    }

    private void placeLeafCluster(IWorldGenerationReader world, Random random, BlockPos pos, BlockStateProvider state, Set<BlockPos> leavesPos) {
        FeatureUtil.placeLeafBlock(world, random, pos, state, leavesPos);
        FeatureUtil.placeLeafBlock(world, random, pos.func_177974_f(), state, leavesPos);
        FeatureUtil.placeLeafBlock(world, random, pos.func_177968_d(), state, leavesPos);
        FeatureUtil.placeLeafBlock(world, random, pos.func_177982_a(1, 0, 1), state, leavesPos);
    }

    public int func_230374_a_(Random random, int i, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        return 0;
    }

    protected boolean func_230373_a_(Random random, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

