/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;

public class CanopyFeature
extends Feature<BaseTreeFeatureConfig> {
    int difference = 0;
    BlockPos validPos = new BlockPos(0, 0, 0);

    public CanopyFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        boolean foundDirt = false;
        for (int dy = pos.func_177956_o(); dy >= 0; --dy) {
            Material materialUnder = reader.func_180495_p(new BlockPos(pos.func_177958_n(), dy - 1, pos.func_177952_p())).func_185904_a();
            if (materialUnder == Material.field_151577_b || materialUnder == Material.field_151578_c) {
                foundDirt = true;
                this.validPos = pos = new BlockPos(pos.func_177958_n(), dy, pos.func_177952_p());
                break;
            }
            if (materialUnder == Material.field_151576_e || materialUnder == Material.field_151595_p) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (Direction e : Direction.Plane.HORIZONTAL) {
            if (reader.func_180495_p(pos.func_177972_a(e)).func_185904_a() != Material.field_151575_d) continue;
            return false;
        }
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place((IWorldGenerationReader)reader, rand, pos, set, set1, mutableboundingbox, config);
        this.difference = mutableboundingbox.field_78895_b - pos.func_177956_o();
        mutableboundingbox.field_78895_b = pos.func_177956_o();
        mutableboundingbox.field_78894_e -= this.difference;
        if (flag && !set.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(p_236405_6_ -> p_236405_6_.func_225576_a_(reader, rand, list, list1, set2, mutableboundingbox));
            }
            VoxelShapePart voxelshapepart = this.func_236403_a_((IWorld)reader, mutableboundingbox, set, set2);
            Template.func_222857_a((IWorld)reader, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    private boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBoxIn, BaseTreeFeatureConfig configIn) {
        BlockPos blockpos;
        int i = configIn.field_236678_g_.func_236917_a_(rand);
        int j = configIn.field_236677_f_.func_230374_a_(rand, i, configIn);
        int k = i - j;
        int l = configIn.field_236677_f_.func_230376_a_(rand, k);
        if (!configIn.field_227372_q_) {
            int i1 = generationReader.func_205770_a(Heightmap.Type.OCEAN_FLOOR, positionIn).func_177956_o();
            int j1 = generationReader.func_205770_a(Heightmap.Type.WORLD_SURFACE, positionIn).func_177956_o();
            if (j1 - i1 > configIn.field_236680_i_) {
                return false;
            }
            blockpos = new BlockPos(positionIn.func_177958_n(), this.validPos.func_177956_o(), positionIn.func_177952_p());
        } else {
            blockpos = positionIn;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + i + 1 <= 256) {
            OptionalInt optionalint = configIn.field_236679_h_.func_236710_c_();
            int l1 = this.func_241521_a_((IWorldGenerationBaseReader)generationReader, i, blockpos, configIn);
            if (l1 >= i || optionalint.isPresent() && l1 >= optionalint.getAsInt()) {
                List list = configIn.field_236678_g_.func_230382_a_(generationReader, rand, l1, blockpos, p_225557_4_, boundingBoxIn, configIn);
                list.forEach(p_236407_8_ -> configIn.field_236677_f_.func_236752_a_(generationReader, rand, configIn, l1, p_236407_8_, j, l, p_225557_5_, boundingBoxIn));
                return true;
            }
            return false;
        }
        return false;
    }

    private int func_241521_a_(IWorldGenerationBaseReader p_241521_1_, int p_241521_2_, BlockPos p_241521_3_, BaseTreeFeatureConfig p_241521_4_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= p_241521_2_ + 1; ++i) {
            int j = p_241521_4_.field_236679_h_.func_230369_a_(p_241521_2_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.func_239621_a_((Vector3i)p_241521_3_, k, i, l);
                    if (p_241521_4_.field_236681_j_) continue;
                    return i - 2;
                }
            }
        }
        return p_241521_2_;
    }

    protected void func_230367_a_(IWorldWriter world, BlockPos pos, BlockState state) {
        CanopyFeature.func_236408_b_(world, pos, state);
    }

    public static void func_236408_b_(IWorldWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.func_180501_a(p_236408_1_, p_236408_2_, 19);
    }

    private VoxelShapePart func_236403_a_(IWorld p_236403_1_, MutableBoundingBox p_236403_2_, Set<BlockPos> p_236403_3_, Set<BlockPos> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(p_236403_2_.func_78883_b(), p_236403_2_.func_78882_c(), p_236403_2_.func_78880_d());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!p_236403_2_.func_175898_b((Vector3i)blockpos)) continue;
            voxelshapepart.func_199625_a(blockpos.func_177958_n() - p_236403_2_.field_78897_a, blockpos.func_177956_o() - p_236403_2_.field_78895_b, blockpos.func_177952_p() - p_236403_2_.field_78896_c, true, true);
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (p_236403_2_.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - p_236403_2_.field_78897_a, blockpos1.func_177956_o() - p_236403_2_.field_78895_b, blockpos1.func_177952_p() - p_236403_2_.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = p_236403_1_.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.func_185334_h());
                CanopyFeature.func_236408_b_((IWorldWriter)p_236403_1_, (BlockPos)blockpos$mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!p_236403_2_.func_175898_b((Vector3i)blockpos$mutable)) continue;
                voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - p_236403_2_.field_78897_a, blockpos$mutable.func_177956_o() - p_236403_2_.field_78895_b, blockpos$mutable.func_177952_p() - p_236403_2_.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_236403_2_.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - p_236403_2_.field_78897_a, blockpos2.func_177956_o() - p_236403_2_.field_78895_b, blockpos2.func_177952_p() - p_236403_2_.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = p_236403_1_.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    CanopyFeature.func_236408_b_((IWorldWriter)p_236403_1_, (BlockPos)blockpos$mutable, blockstate2);
                    if (p_236403_2_.func_175898_b((Vector3i)blockpos$mutable)) {
                        voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - p_236403_2_.field_78897_a, blockpos$mutable.func_177956_o() - p_236403_2_.field_78895_b, blockpos$mutable.func_177952_p() - p_236403_2_.field_78896_c, true, true);
                    }
                    set1.add(blockpos$mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }
}

