/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.tree;

import com.mojang.serialization.Codec;
import github.thelawf.gensokyoontology.common.world.feature.config.GSKOTreeConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;

public abstract class GSKOBiomeFeature<FC extends GSKOTreeConfig>
extends Feature<FC> {
    public GSKOBiomeFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean isDirtOrGrassBlock(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state == Blocks.field_150346_d.func_176223_P() && state == Blocks.field_196658_i.func_176223_P());
    }

    public boolean isTrunkBlockAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    public boolean isOverMaxTreeCountPerChunk(ISeedReader reader, BlockPos pos, int maxCount) {
        int count = 0;
        ChunkPos chunkPos = reader.func_217349_x(pos).func_76632_l();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                if (!this.hasTree(reader, (BlockPos)mutable.func_181079_c(chunkPos.field_77276_a * 16 + xOffset, reader.func_217301_I(), chunkPos.field_77275_b * 16 + zOffset))) continue;
                ++count;
            }
        }
        return count >= maxCount;
    }

    public boolean hasTree(ISeedReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
        });
    }

    public BlockPos getSurfacePos(ISeedReader reader, BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), reader.func_217349_x(pos).func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
    }
}

