/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.feature.tree;

import com.mojang.serialization.Codec;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.common.util.world.FeatureUtil;
import github.thelawf.gensokyoontology.common.world.feature.config.MagicForestConfig;
import github.thelawf.gensokyoontology.common.world.feature.tree.GSKOBiomeFeature;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;

public class MagicForestFeature
extends GSKOBiomeFeature<MagicForestConfig> {
    public MagicForestFeature(Codec<MagicForestConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, MagicForestConfig config) {
        BlockPos surfacePos = this.getSurfacePos(reader, pos);
        if (this.isDirtOrGrassBlock((IWorldGenerationBaseReader)reader, surfacePos)) {
            return false;
        }
        for (int j = 0; j < GSKOMathUtil.randomRange(config.minHeight, config.maxHeight); ++j) {
            FeatureUtil.placeTrunkPattern(reader, rand, surfacePos.func_177981_b(j), config.getTrunk());
        }
        int layerCount = GSKOMathUtil.randomRange(config.foliageLayer.layerCountMin, config.foliageLayer.layerCountMax);
        for (int j = 0; j < layerCount && config.foliageLayer.foliageShape.xRadius - j != 1; ++j) {
            BlockPos center = new BlockPos((Vector3i)FeatureUtil.randomOffset(surfacePos.func_177981_b(config.maxHeight - 2 + j)));
            FeatureUtil.fillEllipse((IWorldGenerationReader)reader, center, rand, config.getFoliage(), config.foliageLayer.foliageShape.xRadius - j, true);
        }
        return true;
    }
}

