/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.layer;

import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomesProvider;
import github.thelawf.gensokyoontology.common.world.layer.AddMistyLakeLayer;
import github.thelawf.gensokyoontology.common.world.layer.AddRiverLayer;
import github.thelawf.gensokyoontology.common.world.layer.GSKORiverLayer;
import github.thelawf.gensokyoontology.common.world.layer.GenerateCommonLayer;
import github.thelawf.gensokyoontology.common.world.layer.YoukaiMountainValleyLayer;
import java.util.Iterator;
import java.util.function.LongFunction;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.area.LazyArea;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class GSKOLayerUtil
extends Layer {
    private final LazyArea area;

    public GSKOLayerUtil(IAreaFactory<LazyArea> lazyAreaFactoryIn) {
        super(() -> null);
        this.area = (LazyArea)lazyAreaFactoryIn.make();
    }

    public static Layer makeGSKOLayers(long seed, Registry<Biome> registry) {
        IAreaFactory areaFactory = GSKOLayerUtil.buildBiomes(context -> new LazyAreaLayerContext(25, seed, context), registry);
        return new GSKOLayerUtil(areaFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> buildBiomes(LongFunction<C> context, Registry<Biome> registry) {
        IAreaFactory area = GenerateCommonLayer.INSTANCE.setUp(registry).func_202823_a((IExtendedNoiseRandom)context.apply(1L));
        area = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1001L), area);
        area = YoukaiMountainValleyLayer.INSTANCE.setup(registry).func_202713_a((IExtendedNoiseRandom)context.apply(1007L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1002L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1003L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1004L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1005L), area);
        area = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1006L), area);
        IAreaFactory river = GSKOLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, area, 0, context);
        river = GSKORiverLayer.INSTANCE.setUp(registry).func_202713_a((IExtendedNoiseRandom)context.apply(7L), area);
        river = AddMistyLakeLayer.INSTANCE.setUp(registry).func_202713_a((IExtendedNoiseRandom)context.apply(30L), area);
        river = GSKOLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, area, 2, context);
        river = GSKOLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, area, 2, context);
        river = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(10L), river);
        area = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(3008L), area);
        area = AddRiverLayer.INSTANCE.setup(registry).func_202707_a((IExtendedNoiseRandom)context.apply(3001L), area, river);
        return area;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    @Nonnull
    public Biome func_242936_a(Registry<Biome> biomes, int x, int z) {
        int id = this.area.func_202678_a(x, z);
        Biome biome = (Biome)biomes.func_148745_a(id);
        if (biome == null) {
            throw new IllegalStateException("Unknown biome id emitted by layers: " + id);
        }
        return biome;
    }

    public static int getId(Registry<Biome> biomes, RegistryKey<Biome> key) {
        return biomes.func_148757_b(biomes.func_230516_a_(key));
    }

    public static int getGSKORiver(INoiseRandom random, Registry<Biome> biomes, int value) {
        Iterator<RegistryKey<Biome>> iterator = GSKOBiomesProvider.GSKO_BIOMES.iterator();
        if (iterator.hasNext()) {
            RegistryKey<Biome> biome = iterator.next();
            return Math.max(value, GSKOLayerUtil.getId(biomes, biome));
        }
        return value;
    }

    public static int getMistyLake(INoiseRandom random, Registry<Biome> biomes, int value) {
        return value == GSKOLayerUtil.getId(biomes, GSKOBiomes.MAGIC_FOREST_KEY) && random.func_202696_a(10) > 5 ? value : GSKOLayerUtil.getId(biomes, GSKOBiomes.MISTY_LAKE_KEY);
    }

    public static int getWindGoddessLake(INoiseRandom random, Registry<Biome> biomes, int value) {
        return value == GSKOLayerUtil.getId(biomes, GSKOBiomes.YOUKAI_MOUNTAIN_KEY) && random.func_202696_a(10) > 8 ? value : GSKOLayerUtil.getId(biomes, GSKOBiomes.WIND_GODDESS_LAKE_KEY);
    }
}

