/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.structure;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.jetbrains.annotations.NotNull;

public class HumanVillageStructure
extends Structure<NoFeatureConfig> {
    public HumanVillageStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @NotNull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @NotNull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean func_230363_a_(@NotNull ChunkGenerator chunkGenerator, @NotNull BiomeProvider provider, long seed, @NotNull SharedSeedRandom chunkRandom, int chunkX, int chunkZ, @NotNull Biome biome, @NotNull ChunkPos chunkPos, @NotNull NoFeatureConfig config) {
        BlockPos centerOfChunk = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
        int landHeight = chunkGenerator.func_222529_a(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return topBlock.func_204520_s().func_206888_e();
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i225876_1_, int p_i225876_2_, int p_i225876_3_, MutableBoundingBox p_i225876_4_, int p_i225876_5_, long p_i225876_6_) {
            super(p_i225876_1_, p_i225876_2_, p_i225876_3_, p_i225876_4_, p_i225876_5_, p_i225876_6_);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistry, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos pos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistry, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistry.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("gensokyoontology", "human_village/start_pool")), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)pos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.field_75075_a.forEach(piece -> --piece.func_74874_b().field_78897_a);
            this.func_202500_a();
        }
    }
}

