/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.world.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.tileentity.DisposableSpawnerTile;
import github.thelawf.gensokyoontology.core.init.BlockRegistry;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.jetbrains.annotations.NotNull;

public class ScarletMansionPieces {
    public static IStructurePieceType TYPE = IStructurePieceType.func_214750_a(Piece::new, (String)"scarlet_devil_mansion");
    public static final String MODID = "gensokyoontology";
    public static final String STRUCTURE_PATH = "scarlet_devil_mansion/";
    public static final String LOOT_PATH = "chests/";
    public static final Map<ResourceLocation, BlockPos> OFFSET = new ImmutableMap.Builder().put((Object)ScarletMansionPieces.withStructureRL("mansion_0_0_0"), (Object)new BlockPos(-47, 0, 0)).put((Object)ScarletMansionPieces.withStructureRL("mansion_1_0_0"), (Object)new BlockPos(0, 0, 0)).put((Object)ScarletMansionPieces.withStructureRL("mansion_2_0_0"), (Object)new BlockPos(46, 0, 0)).put((Object)ScarletMansionPieces.withStructureRL("mansion_3_0_0"), (Object)new BlockPos(74, 0, 0)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_0_1"), (Object)new BlockPos(-47, 0, -47)).put((Object)ScarletMansionPieces.withStructureRL("mansion_1_0_1"), (Object)new BlockPos(0, 0, -47)).put((Object)ScarletMansionPieces.withStructureRL("mansion_2_0_1"), (Object)new BlockPos(46, 0, -47)).put((Object)ScarletMansionPieces.withStructureRL("mansion_3_0_1"), (Object)new BlockPos(74, 0, -47)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_0_2"), (Object)new BlockPos(-47, 0, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_1_0_2"), (Object)new BlockPos(0, 0, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_2_0_2"), (Object)new BlockPos(46, 0, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_3_0_2"), (Object)new BlockPos(74, 0, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_1_0"), (Object)new BlockPos(-47, 47, 0)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_1_1"), (Object)new BlockPos(-47, 47, -32)).put((Object)ScarletMansionPieces.withStructureRL("mansion_1_1_1"), (Object)new BlockPos(0, 47, -32)).put((Object)ScarletMansionPieces.withStructureRL("mansion_2_1_1"), (Object)new BlockPos(46, 47, -32)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_1_2"), (Object)new BlockPos(-47, 47, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_1_1_2"), (Object)new BlockPos(0, 47, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_2_1_2"), (Object)new BlockPos(46, 47, -65)).put((Object)ScarletMansionPieces.withStructureRL("mansion_0_2_1"), (Object)new BlockPos(-47, 74, -47)).put((Object)ScarletMansionPieces.withStructureRL("garden_sw"), (Object)new BlockPos(-81, -1, 33)).put((Object)ScarletMansionPieces.withStructureRL("garden_front_left"), (Object)new BlockPos(-33, -1, 33)).put((Object)ScarletMansionPieces.withStructureRL("garden_front"), (Object)new BlockPos(15, -1, 33)).put((Object)ScarletMansionPieces.withStructureRL("garden_front_right"), (Object)new BlockPos(37, -1, 33)).put((Object)ScarletMansionPieces.withStructureRL("garden_se"), (Object)new BlockPos(85, -1, 33)).put((Object)ScarletMansionPieces.withStructureRL("garden_maze_1"), (Object)new BlockPos(-81, -1, -13)).put((Object)ScarletMansionPieces.withStructureRL("garden_maze_2"), (Object)new BlockPos(-81, -1, -61)).put((Object)ScarletMansionPieces.withStructureRL("garden_maze_3"), (Object)new BlockPos(111, -1, -13)).put((Object)ScarletMansionPieces.withStructureRL("garden_maze_4"), (Object)new BlockPos(111, -1, -61)).put((Object)ScarletMansionPieces.withStructureRL("garden_nw"), (Object)new BlockPos(-81, -1, -109)).put((Object)ScarletMansionPieces.withStructureRL("garden_back_left"), (Object)new BlockPos(-47, -1, -109)).put((Object)ScarletMansionPieces.withStructureRL("garden_back"), (Object)new BlockPos(0, -1, -109)).put((Object)ScarletMansionPieces.withStructureRL("garden_back_right"), (Object)new BlockPos(48, -1, -109)).put((Object)ScarletMansionPieces.withStructureRL("garden_ne"), (Object)new BlockPos(96, -1, -107)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_01"), (Object)new BlockPos(-44, -22, -15)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_02"), (Object)new BlockPos(-44, -22, -63)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_03"), (Object)new BlockPos(4, -22, -15)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_04"), (Object)new BlockPos(4, -22, -63)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_05"), (Object)new BlockPos(52, -22, -15)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_06"), (Object)new BlockPos(52, -22, -63)).put((Object)ScarletMansionPieces.withStructureRL("dungeon_07"), (Object)new BlockPos(-22, -22, 32)).build();
    public static final List<ResourceLocation> LOOT_TABLES = ImmutableList.of((Object)ScarletMansionPieces.withLootRL("mansion_danmaku_loot.json"), (Object)ScarletMansionPieces.withLootRL("mansion_vanilla_loot.json"), (Object)ScarletMansionPieces.withLootRL("mansion_shot_loot.json"), (Object)ScarletMansionPieces.withLootRL("mansion_small_shot_loot.json"), (Object)ScarletMansionPieces.withLootRL("mansion_color_shot_loot.json"));

    public static ResourceLocation withStructureRL(String name) {
        return GensokyoOntology.withRL(STRUCTURE_PATH + name);
    }

    public static ResourceLocation withLootRL(String name) {
        return GensokyoOntology.withRL(LOOT_PATH + name);
    }

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieces) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (Map.Entry<ResourceLocation, BlockPos> entry : OFFSET.entrySet()) {
            String name = entry.getKey().toString().replace("gensokyoontology:scarlet_devil_mansion/", "");
            BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(ScarletMansionPieces.setRotFrom(ScarletMansionPieces.warp(name)));
            BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
            pieces.add((StructurePiece)new Piece(templateManager, name, blockpos, rotation, Mirror.NONE));
        }
    }

    private static Rotation setRotFrom(Vector3i relative) {
        return Rotation.NONE;
    }

    private static Vector3i warp(String templateName) {
        String regex = "[^0-9]+";
        Pattern pattern = Pattern.compile(regex);
        List<String> ls = Arrays.asList(pattern.split(templateName));
        List list = ls.stream().filter(s -> !Objects.equals(s, "")).collect(Collectors.toList());
        if (list.size() <= 1) {
            return new Vector3i(0, 0, 0);
        }
        return new Vector3i(Integer.parseInt((String)list.get(0)), Integer.parseInt((String)list.get(1)), Integer.parseInt((String)list.get(2)));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation templateName;
        private final Rotation rotation;
        private final Mirror mirror;

        public Piece(TemplateManager templateManager, String templateName, BlockPos pos, Rotation rotation, Mirror mirror) {
            super(TYPE, 0);
            this.templateName = GensokyoOntology.withRL(ScarletMansionPieces.STRUCTURE_PATH + templateName);
            BlockPos blockPos = OFFSET.get(this.templateName);
            this.field_186178_c = pos.func_177982_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.rotation = rotation;
            this.mirror = mirror;
            this.loadTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(TYPE, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
            this.loadTemplate(templateManager);
        }

        private void loadTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(false).func_186220_a(this.rotation).func_186214_a(this.mirror).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(@NotNull CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(@NotNull String function, @NotNull BlockPos pos, @NotNull IServerWorld worldIn, @NotNull Random rand, @NotNull MutableBoundingBox sbb) {
            TileEntity tileentity;
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), 2);
                tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(LOOT_TABLES.get(rand.nextInt(LOOT_TABLES.size())), rand.nextLong());
                }
            }
            if ("gensokyoontology:disposable_spawner_tileentity".equals(function)) {
                worldIn.func_180501_a(pos, ((Block)BlockRegistry.DISPOSABLE_SPAWNER.get()).func_176223_P(), 2);
                tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof DisposableSpawnerTile && this.templateName.func_110623_a().equals("mansion_1_0_2")) {
                    ((DisposableSpawnerTile)tileentity).setEntityType((EntityType)EntityRegistry.REMILIA_SCARLET.get());
                }
            }
        }
    }
}

