/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.core;

import com.mojang.serialization.Codec;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.world.feature.placer.BranchTrunkPlacer;
import github.thelawf.gensokyoontology.common.world.feature.placer.MagicTrunkPlacer;
import github.thelawf.gensokyoontology.common.world.feature.placer.RedwoodTrunkPlacer;
import github.thelawf.gensokyoontology.common.world.feature.placer.SphericalFoliagePlacer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gensokyoontology", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlacerRegistry {
    public static final List<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = new ArrayList();
    public static final TrunkPlacerType<BranchTrunkPlacer> BRANCH_TRUNK_PLACER = PlacerRegistry.registerTrunkPlacer("branch_trunk_placer", BranchTrunkPlacer.CODEC);
    public static final TrunkPlacerType<MagicTrunkPlacer> MAGIC_TRUNK_PLACER = PlacerRegistry.registerTrunkPlacer("magic_trunk_placer", MagicTrunkPlacer.CODEC);
    public static final FoliagePlacerType<SphericalFoliagePlacer> SPHERICAL_FOLIAGE_PLACER = PlacerRegistry.foliage(GensokyoOntology.withRL("spherical_foliage_placer"), SphericalFoliagePlacer.CODEC);

    public static void registerPlacers() {
        Registry registry = Registry.field_239701_aw_;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("gensokyoontology", "redwood_trunk_placer"), (Object)new TrunkPlacerType(RedwoodTrunkPlacer.CODEC));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("gensokyoontology", "magic_trunk_placer"), (Object)new TrunkPlacerType(MagicTrunkPlacer.CODEC));
    }

    public static <P extends AbstractTrunkPlacer> TrunkPlacerType<P> registerTrunkPlacer(String id, Codec<P> codec) {
        return (TrunkPlacerType)Registry.func_218322_a((Registry)Registry.field_239701_aw_, (ResourceLocation)GensokyoOntology.withRL(id), (Object)new TrunkPlacerType(codec));
    }

    public static <P extends FoliagePlacer> FoliagePlacerType<P> foliage(ResourceLocation name, Codec<P> codec) {
        FoliagePlacerType type = new FoliagePlacerType(codec);
        type.setRegistryName(name);
        FOLIAGE_PLACER_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void registerFoliagePlacers(RegistryEvent.Register<FoliagePlacerType<?>> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])FOLIAGE_PLACER_TYPES.toArray(new FoliagePlacerType[0]));
    }
}

